% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{[[<-,Seurat}
\alias{[[<-,Seurat}
\alias{[[<-.Seurat}
\alias{\S4method{[[<-}{Seurat,character,missing,Assay}}
\alias{[[<-,Seurat,character,missing,Assay-method}
\alias{[[<-,Seurat,character,missing,Assay5-method}
\alias{[[<-,Seurat,character,missing,DimReduc-method}
\alias{[[<-,Seurat,character,missing,Graph-method}
\alias{[[<-,Seurat,character,missing,Neighbor-method}
\alias{[[<-,Seurat,character,missing,SeuratCommand-method}
\alias{[[<-,Seurat,character,missing,SpatialImage-method}
\title{Add Subobjects}
\usage{
\S4method{[[}{Seurat,character,missing,Assay}(x, i, j, ...) <- value

\S4method{[[}{Seurat,character,missing,Assay5}(x, i, j, ...) <- value

\S4method{[[}{Seurat,character,missing,DimReduc}(x, i, j, ...) <- value

\S4method{[[}{Seurat,character,missing,Graph}(x, i, j, ...) <- value

\S4method{[[}{Seurat,character,missing,Neighbor}(x, i, j, ...) <- value

\S4method{[[}{Seurat,character,missing,SeuratCommand}(x, i, j, ...) <- value

\S4method{[[}{Seurat,character,missing,SpatialImage}(x, i, j, ...) <- value
}
\arguments{
\item{x}{A \code{\link{Seurat}} object}

\item{i}{Name to add subobject as}

\item{j}{Ignored}

\item{...}{Ignored}

\item{value}{A valid subobject (eg. a \link[=Assay]{v3} or \link[=Assay5]{v5}
assay, or a \link[=DimReduc]{dimensional reduction})}
}
\value{
\code{x} with \code{value} added as \code{i}
}
\description{
Add subobjects containing expression, dimensional reduction, or other
containerized data to a \code{\link{Seurat}} object. Subobjects can be
accessed with \code{\link[=[[.Seurat]{[[}} and manipulated directly within
the \code{Seurat} object or used independently
}
\seealso{
See \link[=[[.Seurat]{here} for pulling subobjects using \code{[[},
\link[=$.Seurat]{here} for adding metadata with \code{[[<-}, and
\link[=[[<-,Seurat,NULL]{here} for removing subobjects and cell-level meta
data with \code{[[<-}

Seurat object, validity, and interaction methods
\code{\link{$.Seurat}()},
\code{\link{Seurat-class}},
\code{\link{Seurat-validity}},
\code{\link{[[.Seurat}()},
\code{\link{[[<-,Seurat,NULL}},
\code{\link{dim.Seurat}()},
\code{\link{dimnames.Seurat}()},
\code{\link{merge.Seurat}()},
\code{\link{names.Seurat}()},
\code{\link{subset.Seurat}()}
}
\concept{seurat}
