\name{RMmastein}
\alias{RMmastein}
\title{Ma-Stein operator}
\description{
 \command{\link{RMmastein}} is a univariate stationary covariance model
 depending on a variogram or covariance model on the real axis.
 The corresponding covariance function only depends on the difference
 \eqn{h}{h} between two points and is given by

 \deqn{C(h, t)=\frac{\Gamma(\nu + \phi(t))\Gamma(\nu + \delta)}{
 \Gamma(\nu + \phi(t) + \delta) \Gamma(\nu)} W_{\nu +
 \phi(t)}(\|h -Vt\|)}{C(h, t)= [ Gamma(nu + phi(t))Gamma(nu +
 delta) ] / [Gamma(nu + phi(t) + delta) Gamma(nu) ] W_{nu +
 phi(t)}(|h - Vt|)}
 
if \eqn{\phi} is a variogram model.
It is given by
\deqn{C(h, t)=\frac{\Gamma(\nu + \phi(0)-\phi(t))\Gamma(\nu + \delta)}{
 \Gamma(\nu + \phi(0)-\phi(t) + \delta) \Gamma(\nu)} W_{\nu +
 \phi(t)}(\|h -Vt\|)}{C(h, t)= [ Gamma(nu + phi(0)-phi(t))Gamma(nu +
 delta) ] / [Gamma(nu + phi(0)-phi(t) + delta) Gamma(nu) ] W_{nu + phi(0)-phi(t)}(|h - Vt|)}

if \eqn{\phi} is a covariance model.

Here \eqn{\Gamma} is the Gamma function; \eqn{W} is the Whittle-Matern
model (RMwhittle).
}

\usage{
RMmastein(phi, nu, delta, var, scale, Aniso, proj)
}
\arguments{
 \item{phi}{an \command{\link{RMmodel}} on the real axis}
 \item{nu}{numerical value; positive; smoothness parameter of the
 Whittle-Matern model (for \eqn{t=0})} 
 \item{delta}{a numerical value; \eqn{\delta} must be greater than or
 equal to half the dimension of \eqn{h}}
 \item{var,scale,Aniso,proj}{optional arguments; same meaning for any
 \command{\link{RMmodel}}. If not passed, the above
 covariance function remains unmodified.}
}
\details{
 See Stein (2005) formula (12).
 
 Instead of the velocity parameter \eqn{V} in the original model
 description, a preceeding anisotropy matrix is chosen appropriately:
 
 \deqn{\left( \begin{array}{cc} A & -V \\ 0 &
 1\end{array}\right)}{matrix(c(A, -V, 0, 1), nr=2, by=TRUE)}
 A is a spatial transformation matrix.
 (I.e. (x,t) is multiplied from left on the above matrix and
 the first elements of the obtained vector are intepreted as
 new spatial components and only these components are used to form
 the argument in the Whittle-Matern function.)
 The last component in the new coordinates is the time which is
 passed to \eqn{\phi}{phi}. (Velocity is assumed to be zero in
 the new coordinates.)
 
 Note, that for numerical reasons, \eqn{\nu+\phi+d} may not exceed
 the value 80.0. If exceeded the algorithm fails. 
}
\value{
 \command{\link{RMmastein}} returns an object of class \code{\link[=RMmodel-class]{RMmodel}}
}
\references{
 \itemize{
 \item Ma, C. (2003)
 Spatio-temporal covariance functions generated by mixtures.
 \emph{Math. Geol.}, \bold{34}, 965-975.
 \item Stein, M.L. (2005) Space-time covariance functions. \emph{JASA},
 \bold{100}, 310-321.
 }
}

\author{Martin Schlather, \email{schlather@math.uni-mannheim.de}
}
\seealso{
 \command{\link{RMwhittle}},
 \command{\link{RMmodel}},
 \command{\link{RFsimulate}},
 \command{\link{RFfit}}.
}


\keyword{spatial}
\keyword{models}



\examples{
RFoptions(seed=0) ## *ANY* simulation will have the random seed 0; set
##                   RFoptions(seed=NA) to make plotthem all random again
\dontshow{StartExample()}
model <- RMmastein(RMgauss(), nu=1, delta=10)
plot(RMexp(), model.mastein=model, dim=2)

x <- seq(0, 10, 0.1)
plot(RFsimulate(model, x=x, y=x))
\dontshow{FinalizeExample()}
}