\name{plot.pvclust}
\alias{plot.pvclust}
\alias{text.pvclust}
\title{Draws Dendrogram with P-values for Pvclust Object}
\description{
  plot dendrogram for a \code{pvclust} object and add \eqn{p}-values for
  clusters.
}
\usage{
\method{plot}{pvclust}(x, print.pv=TRUE, print.num=TRUE, float=0.01,
  col.pv=c(si=4, au=2, bp=3, edge=8), cex.pv=0.8, font.pv=NULL,
  col=NULL, cex=NULL, font=NULL, lty=NULL, lwd=NULL, main=NULL,
  sub=NULL, xlab=NULL, ...)

\method{text}{pvclust}(x, col=c(au=2, bp=3, edge=8), print.num=TRUE,
  float=0.01, cex=NULL, font=NULL, ...)
}
\arguments{
  \item{x}{object of class \code{pvclust}, which is generated by
    function \code{pvclust}. See \code{\link{pvclust}} for details.}
  \item{print.pv}{logical flag to specify whether print \eqn{p}-values
  around the edges (clusters), or character vector of length 0 to 3
  which specifies the names of \eqn{p}-values to print
  (\code{c("si", "au", "bp")} for example).}
  \item{print.num}{logical flag to specify whether print edge numbers
    below clusters.}
  \item{float}{numeric value to adjust the height of \eqn{p}-values from
  edges.}
  \item{col.pv}{named numeric vector to specify the colors for
    \eqn{p}-values and edge numbers. For back compatibility
    it can also be unnamed numeric vector of length 3, which
    corresponds to the color of AU, BP values and edge numbers.}
  \item{cex.pv}{numeric value which specifies the size of characters for
  \eqn{p}-values and edge numbers. See \code{cex} argument for
  \code{\link[graphics]{par}}.}
  \item{font.pv}{numeric value which specifies the font of characters
    for \eqn{p}-values and edge numbers. See \code{font} argument for
    \code{\link[graphics]{par}}.}
  \item{col, cex, font}{in \code{text} function, they correspond to
    \code{col.pv}, \code{cex.pv} and \code{font.pv} in \code{plot}
    function, respectively. In \code{plot} function they are used as
    generic graphic parameters.}
  \item{lty, lwd, main, sub, xlab, ...}{
    generic graphic parameters. See \code{\link[graphics]{par}} for
    details.}
}
\details{
  This function plots a dendrogram with \eqn{p}-values for given object
  of class \code{pvclust}.
  SI \eqn{p}-value (printed in blue color in default) is the approximately unbiased
  \eqn{p}-value for selective inference, and
  AU \eqn{p}-value (printed in red color in default) is also the approximately unbiased
  \eqn{p}-value but for non-selective inference. They ared calculated by multiscale bootstrap
  resampling. BP value (printed in green color in default) is "bootstrap
  probability" value, which is less accurate than AU value as
  \eqn{p}-value. One can consider that clusters (edges) with high SI or AU
  values (e.g. 95\%) are strongly supported by data.
  SI value is newly introduced in Terada and Shimodaira (2017) for selective inference,
  which is more appropriate for testing clusters identified by looking at the tree.
  AU value has been used since Shimodaira (2002), which is not designed for selective inference.
  AU is valid when you know the clusters before looking at the data.
  See also documatation (Multiscale Bootstrap using Scaleboot Package, verison 0.4-0 or higher) in \code{scaleboot} package.
}
\seealso{\code{\link{text.pvclust}}}
\references{
  Terada, Y. and Shimodaira, H. (2007)
  "Selective inference for the problem of regions via multiscale bootstrap",
  \emph{arXiv:1711.00949}.

  Shimodaira, H. (2004)
  "Approximately unbiased tests of regions using multistep-multiscale
  bootstrap resampling",
  \emph{Annals of Statistics}, 32, 2616-2641.

  Shimodaira, H. (2002)
  "An approximately unbiased test of phylogenetic tree selection",
  \emph{Systematic Biology}, 51, 492-508.
}
\author{Ryota Suzuki \email{suzuki@ef-prime.com}}
\keyword{hplot}
