% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_variables.R
\name{rename_variables}
\alias{rename_variables}
\alias{rename_variables.draws}
\title{Rename variables in \code{draws} objects}
\usage{
rename_variables(.x, ...)

\method{rename_variables}{draws}(.x, ...)
}
\arguments{
\item{.x}{(draws) A \code{\link{draws}} object.}

\item{...}{One or more expressions, separated by commas, indicating the
variables to rename. The variable names can be unquoted
(\code{new_name = old_name}) or quoted (\code{"new_name" = "old_name"}). For non-scalar
variables, all elements can be renamed together (\code{"new_name" = "old_name"})
or they can be renamed individually (\code{"new_name[1]" = "old_name[1]"}).}
}
\value{
Returns a \code{\link{draws}} object of the same format as \code{.x}, with variables renamed
according to the expressions provided in \code{...}.
}
\description{
Rename variables in a \code{\link{draws}} object.
}
\examples{
x <- as_draws_df(example_draws())
variables(x)

x <- rename_variables(x, mean = mu, sigma = tau)
variables(x)

x <- rename_variables(x, b = `theta[1]`) # or b  = "theta[1]"
variables(x)

# rename all elements of 'theta' at once
x <- rename_variables(x, alpha = theta)
variables(x)

}
\seealso{
\code{\link{variables}}, \code{\link{mutate_variables}}
}
