% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_bayes.R
\name{r2_bayes}
\alias{r2_bayes}
\title{Bayesian R2}
\usage{
r2_bayes(model, robust = TRUE, ci = 0.89)
}
\arguments{
\item{model}{A Bayesian regression model.}

\item{robust}{Logical, if \code{TRUE}, the median instead of mean is used to
calculate the central tendency of the variances.}

\item{ci}{Value or vector of probability of the CI (between 0 and 1) to be estimated.}
}
\value{
A list with the Bayesian R2 value. For mixed models, a list with the
  Bayesian R2 value and the marginal Bayesian R2 value. The standard errors
  and credible intervals for the R2 values are saved as attributes.
}
\description{
Compute R2 for Bayesian models. For mixed models (including a random part),
it additionally computes the R2 related to the fixed effects only (marginal R2).
}
\details{
\code{r2_bayes()} returns an "unadjusted" R2 value. See \code{\link{r2_loo}}
  to calculate a LOO-adjusted R2, which comes conceptionally closer to an
  adjusted R2 measure.
  \cr \cr
  For mixed models, the conditional and marginal R2 are returned. The marginal
  R2 considers only the variance of the fixed effects, while the conditional
  R2 takes both the fixed and random effects into account.
}
\examples{
library(performance)
if (require("rstanarm")) {
  model <- stan_glm(mpg ~ wt + cyl, data = mtcars, chains = 1, iter = 500, refresh = 0)
  r2_bayes(model)

  model <- stan_lmer(
    Petal.Length ~ Petal.Width + (1 | Species),
    data = iris,
    chains = 1,
    iter = 500,
    refresh = 0
  )
  r2_bayes(model)
}
\dontrun{
if (require("brms")) {
  model <- brms::brm(mpg ~ wt + cyl, data = mtcars)
  r2_bayes(model)

  model <- brms::brm(Petal.Length ~ Petal.Width + (1 | Species), data = iris)
  r2_bayes(model)
}
}
}
\references{
Gelman, A., Goodrich, B., Gabry, J., & Vehtari, A. (2018). R-squared for Bayesian regression models. The American Statistician, 1–6. \doi{10.1080/00031305.2018.1549100}
}
