% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof-phreg.R
\name{gofG.phreg}
\alias{gofG.phreg}
\title{Stratified baseline graphical GOF test for Cox covariates in PH regression}
\usage{
gofG.phreg(x, sim = 0, silent = 1, lm = TRUE, ...)
}
\arguments{
\item{x}{phreg object}

\item{sim}{to simulate som variation from cox model to put on graph}

\item{silent}{to keep it absolutely silent}

\item{lm}{addd line to plot, regressing the cumulatives on each other}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Looks at stratified baseline in Cox model and plots all baselines versus each
other to see if lines are straight, with 50 resample versions under the 
assumptiosn that the stratified Cox is correct
}
\examples{
data(TRACE)

m1 <- phreg(Surv(time,status==9)~strata(vf)+chf+wmi,data=TRACE) 
m2 <- phreg(Surv(time,status==9)~vf+strata(chf)+wmi,data=TRACE) 
par(mfrow=c(2,2))

gofG.phreg(m1)
gofG.phreg(m2)

bplot(m1,log="y")
bplot(m2,log="y")
}
\author{
Thomas Scheike and Klaus K. Holst
}
