% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_functions.R
\name{draw_circle}
\alias{draw_circle}
\title{Draw concentric circles}
\usage{
draw_circle(col = "#00BFFF", use = "focus", max.circle)
}
\arguments{
\item{col}{color of circles}

\item{use}{one of 'focus' or 'cent'}

\item{max.circle}{if use = 'focus' specifies the number of circles to draw}
}
\value{
concentric circles around origin
}
\description{
Draw concentric circles
}
\details{
this function is best used with a concentric layout such as \link{layout_with_focus} and \link{layout_with_centrality}.
}
\examples{
library(igraph)
g <- sample_gnp(10, 0.4)

\dontrun{
library(ggraph)
ggraph(g, layout = "centrality", centrality = degree(g)) +
    draw_circle(use = "cent") +
    geom_edge_link() +
    geom_node_point(shape = 21, fill = "grey25", size = 5) +
    theme_graph() +
    coord_fixed()
}
}
