% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_model_predictions.R
\name{layer_model_predictions}
\alias{layer_model_predictions}
\alias{layer_smooths}
\title{Overlay model predictions or a smooth curve.}
\usage{
layer_model_predictions(vis, ..., model, formula = NULL, model_args = NULL,
  se = FALSE, domain = NULL)

layer_smooths(vis, ..., span = 0.75, se = FALSE)
}
\arguments{
\item{vis}{Visualisation to modify}

\item{...}{Visual properties. Stroke properties control only affect line,
fill properties only affect standard error band.}

\item{model}{Name of the model as a string, e.g. \code{"loess"}, \code{"lm"},
or \code{"MASS::rlm"}. Must be the name of a function that produces a
standard model object with a \code{\link{predict}} method. For
\code{layer_smooth} this is always "loess".}

\item{formula}{Model formula. If not supplied, guessed from the visual
properties, constructing \code{y ~ x}.}

\item{model_args}{A list of additional arguments passed on to the
\code{model} function.}

\item{se}{Also display a point-wise standard error band? Defaults to
\code{FALSE} because interpretation is non-trivial.}

\item{domain}{If \code{NULL} (the default), the domain of the predicted
values will be the same as the domain of the prediction variable in the
data. It can also be a two-element numeric vector specifying the min and
max.}

\item{span}{For \code{layer_smooth}, the span of the loess smoother.}
}
\description{
\code{layer_model_predictions} fits a model to the data and draw it with
\code{layer_paths} and, optionally, \code{layer_ribbons}.
\code{layer_smooths} is a special case of layering model predictions where
the model is a smooth loess curve whose smoothness is controlled by the
\code{span} parameter.
}
\examples{
mtcars \%>\% ggvis(~wt, ~mpg) \%>\% layer_smooths()
mtcars \%>\% ggvis(~wt, ~mpg) \%>\% layer_smooths(se = TRUE)

# Use group by to display multiple smoothes
mtcars \%>\% ggvis(~wt, ~mpg) \%>\% group_by(cyl) \%>\% layer_smooths()

# Control appearance with props
mtcars \%>\% ggvis(~wt, ~mpg) \%>\%
  layer_smooths(se = TRUE, stroke := "red", fill := "red", strokeWidth := 5)

# Control the wiggliness with span. Default is 0.75
mtcars \%>\% ggvis(~wt, ~mpg) \%>\% layer_points() \%>\%
  layer_smooths(span = 0.2)
mtcars \%>\% ggvis(~wt, ~mpg) \%>\% layer_points() \%>\%
  layer_smooths(span = 1)
# Map to an input to modify interactively
mtcars \%>\% ggvis(~wt, ~mpg) \%>\% layer_points() \%>\%
  layer_smooths(span = input_slider(0.2, 1))

# Use other modelling functions with layer_model_predictions
mtcars \%>\% ggvis(~wt, ~mpg) \%>\%
  layer_points() \%>\%
  layer_model_predictions(model = "lm") \%>\%
  layer_model_predictions(model = "MASS::rlm", stroke := "red")

# Custom domain for predictions
mtcars \%>\% ggvis(~wt, ~mpg) \%>\% layer_points() \%>\%
  layer_model_predictions(model = "lm", domain = c(0, 8))
mtcars \%>\% ggvis(~wt, ~mpg) \%>\% layer_points() \%>\%
  layer_model_predictions(model = "lm",
    domain = input_slider(0, 10, value = c(1, 4)))

# layer_smooths() is just compute_smooth() + layer_paths()
# Run loess or other model outside of a visualisation to see what variables
# you get.
mtcars \%>\% compute_smooth(mpg ~ wt)
mtcars \%>\% compute_model_prediction(mpg ~ wt, model = "lm")

mtcars \%>\%
  ggvis(~wt, ~mpg) \%>\%
  layer_points() \%>\%
  compute_smooth(mpg ~ wt) \%>\%
  layer_paths(~pred_, ~resp_, strokeWidth := 2)
}

