% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow-mark.R
\name{shadow_mark}
\alias{shadow_mark}
\title{Show original data as background marks}
\usage{
shadow_mark(past = TRUE, future = FALSE, ..., exclude_layer = NULL)
}
\arguments{
\item{past}{Should raw data from earlier in the animation be shown}

\item{future}{Should raw data from later in the animation be shown}

\item{...}{changes to the shadow data, e.g. \code{alpha = alpha/2} or
\code{colour = 'grey'}}

\item{exclude_layer}{Indexes of layers that should be excluded.}
}
\description{
This shadow lets you show the raw data behind the current frame. Both past
and/or future raw data can be shown and styled as you want.
}
\examples{
# Use any of the aesthetics to add a style to either the past or the future raw data.
# Adding a grouping variable in a transition call prior to calling `shadow_mark()` will
# allow transitioning through different states in time.

p1 <- ggplot(airquality, aes(Day, Temp)) +
  geom_line(color = 'red', size = 1) +
  transition_time(Month) +
  shadow_mark(colour = 'black', size = 0.75)

# animate(p1)

# Add a future = TRUE argument to show data later in the animation.

p2 <- ggplot(airquality, aes(Day, Temp)) +
  geom_line(color = 'red', size = 1) +
  transition_time(Month) +
  shadow_mark(color = 'black', size = 0.75, past = FALSE, future = TRUE)

# animate(p2)

}
\seealso{
Other shadows: 
\code{\link{shadow_null}()},
\code{\link{shadow_trail}()},
\code{\link{shadow_wake}()}
}
\concept{shadows}
