% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{html_esc}
\alias{html_esc}
\title{Escape Characters With Special HTML Meaning}
\usage{
html_esc(x, what = getOption("fansi.html.esc", "<>&'\\""))
}
\arguments{
\item{x}{character vector}

\item{what}{character(1) containing any combination of ASCII characters
"<", ">", "&", "'", or "\"".  These characters are special in HTML contexts
and will be substituted by their HTML entity code.  By default, all
special characters are escaped, but in many cases "<>&" or even "<>" might
be sufficient.
@return \code{x}, but with the \code{what} characters replaced by their HTML entity
codes.}
}
\description{
Arbitrary text may contain characters with special meaning in HTML, which may
cause HTML display to be corrupted if they are included unescaped in a web
page.  This function escapes those special characters so they do not
interfere with the HTML markup generated by e.g. \code{\link{to_html}}.
}
\note{
Non-ASCII strings are converted to and returned in UTF-8 encoding.
}
\examples{
html_esc("day > night")
html_esc("<SPAN>hello world</SPAN>")
}
\seealso{
Other HTML functions: 
\code{\link{in_html}()},
\code{\link{make_styles}()},
\code{\link{to_html}()}
}
\concept{HTML functions}
