% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_leverage_centrality.R
\name{get_leverage_centrality}
\alias{get_leverage_centrality}
\title{Get leverage centrality}
\usage{
get_leverage_centrality(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A data frame with leverage centrality values for each of the nodes.
}
\description{
Get the leverage centrality values for all nodes in the graph. Leverage
centrality is a measure of the relationship between the degree of a given
node and the degree of each of its neighbors, averaged over all neighbors. A
node with negative leverage centrality is influenced by its neighbors, as the
neighbors connect and interact with far more nodes. A node with positive
leverage centrality influences its neighbors since the neighbors tend to have
far fewer connections.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get leverage centrality values
# for all nodes in the graph
graph \%>\%
  get_leverage_centrality()

# Add the leverage centrality
# values to the graph as a
# node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_leverage_centrality(.))

# Display the graph's node data frame
graph \%>\% get_node_df()

}
