% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-oo-api.R
\name{desc_bump_version}
\alias{desc_bump_version}
\title{Increase the version number in DESCRIPTION}
\usage{
desc_bump_version(which, file = ".", normalize = FALSE)
}
\arguments{
\item{which}{Which component to increase. See details below.}

\item{file}{DESCRIPTION file to use. By default the DESCRIPTION
file of the current package (i.e. the package the working directory
is part of) is used.}

\item{normalize}{Whether to normalize the write when writing back
the result. See \code{\link{desc_normalize}}.}
}
\description{
The \code{which} parameter specifies which component to increase.
It can be a string referring to a component: \sQuote{major},
\sQuote{minor}, \sQuote{patch} or \sQuote{dev}, or an integer
scalar, for the latter components are counted from one, and the
beginning. I.e. component one is equivalent to \sQuote{major}.
}
\details{
If a component is bumped, then the ones after it are zeroed out.
Trailing zero components are omitted from the new version number,
but if the old version number had at least two or three components, then
the one will also have two or three.

The bumping of the \sQuote{dev} version (the fourth component) is
special: if the original version number had less than four components,
and the \sQuote{dev} version is bumped, then it is set to \code{9000}
instead of \code{1}. This is a convention often used by R developers,
it was originally invented by Winston Chang.

Both \code{$set_version()} and \code{$bump_version()} use dots to
separate the version number components.
}
\seealso{
Other version numbers: \code{\link{desc_get_version}},
  \code{\link{desc_set_version}}
}
\concept{version numbers}
