% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf_int.R
\name{linear_contrast}
\alias{linear_contrast}
\title{Calculate confidence intervals and p-values for linear contrasts of
regression coefficients in a fitted model}
\usage{
linear_contrast(
  obj,
  vcov,
  contrasts,
  level = 0.95,
  test = "Satterthwaite",
  ...,
  p_values = FALSE
)
}
\arguments{
\item{obj}{Fitted model for which to calculate confidence intervals.}

\item{vcov}{Variance covariance matrix estimated using \code{vcovCR} or a
character string specifying which small-sample adjustment should be used to
calculate the variance-covariance.}

\item{contrasts}{A contrast matrix, or a list of multiple contrast matrices
to test. See details and examples.}

\item{level}{Desired coverage level for confidence intervals.}

\item{test}{Character vector specifying which small-sample corrections to
calculate. \code{"z"} returns a z test (i.e., using a standard normal
reference distribution). \code{"naive-t"} returns a t test with \code{m -
1} degrees of freedom, where \code{m} is the number of unique clusters.
\code{"naive-tp"} returns a t test with \code{m - p} degrees of freedom,
where \code{p} is the number of regression coefficients in \code{obj}.
\code{"Satterthwaite"} returns a Satterthwaite correction. Unlike in
\code{coef_test()}, \code{"saddlepoint"} is not currently supported in
\code{conf_int()} because saddlepoint confidence intervals do not have a
closed-form solution.}

\item{...}{Further arguments passed to \code{\link{vcovCR}}, which are only
needed if \code{vcov} is a character string.}

\item{p_values}{Logical indicating whether to report p-values. The default
value is \code{FALSE}.}
}
\value{
A data frame containing estimated contrasts, standard
  errors, confidence intervals, and (optionally) p-values.
}
\description{
\code{linear_contrast} reports confidence intervals and (optionally) p-values
for linear contrasts of regression coefficients from a fitted model, using a
sandwich estimator for the standard errors and (optionally) a small sample
correction for the critical values. The default small-sample correction is
based on a Satterthwaite approximation.
}
\details{
Constraints can be specified directly as q X p matrices or
  indirectly through \code{\link{constrain_pairwise}},
  \code{\link{constrain_equal}}, or \code{\link{constrain_zero}}.
}
\examples{

data("ChickWeight", package = "datasets")
lm_fit <- lm(weight ~ 0 + Diet + Time:Diet, data = ChickWeight)

# Pairwise comparisons of diet-by-time slopes
linear_contrast(lm_fit, vcov = "CR2", cluster = ChickWeight$Chick, 
                contrasts = constrain_pairwise("Diet.:Time", reg_ex = TRUE))


if (requireNamespace("carData", quietly = TRUE)) withAutoprint({

  data(Duncan, package = "carData")
  Duncan$cluster <- sample(LETTERS[1:8], size = nrow(Duncan), replace = TRUE)

  Duncan_fit <- lm(prestige ~ 0 + type + income + type:income + type:education, data=Duncan)
  # Note that type:income terms are interactions because main effect of income is included
  # but type:education terms are separate slopes for each unique level of type

  # Pairwise comparisons of type-by-education slopes
  linear_contrast(Duncan_fit, vcov = "CR2", cluster = Duncan$cluster,
                  contrasts = constrain_pairwise(":education", reg_ex = TRUE),
                  test = "Satterthwaite")
 
  # Pairwise comparisons of type-by-income interactions
  linear_contrast(Duncan_fit, vcov = "CR2", cluster = Duncan$cluster,
                  contrasts = constrain_pairwise(":income", reg_ex = TRUE, with_zero = TRUE),
                  test = "Satterthwaite")
                  
})

}
\seealso{
\code{\link{vcovCR}}
}
