% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-true.R
\name{chk_true}
\alias{chk_true}
\alias{vld_true}
\title{Check TRUE}
\usage{
chk_true(x, x_name = NULL)

vld_true(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if TRUE using

\code{is.logical(x) && length(x) == 1L && !anyNA(x) && x}
}
\section{Functions}{
\itemize{
\item \code{vld_true()}: Validate TRUE

}}
\examples{
# chk_true
chk_true(TRUE)
try(chk_true(1))
# vld_true
vld_true(TRUE)
vld_true(FALSE)
vld_true(NA)
vld_true(0)
vld_true(c(TRUE, TRUE))
}
\seealso{
\code{\link[=is.logical]{is.logical()}}

\code{\link[=length]{length()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other logical_checkers: 
\code{\link{chk_false}()},
\code{\link{chk_flag}()},
\code{\link{chk_lgl}()},
\code{\link{chk_logical}()}

Other scalar_checkers: 
\code{\link{chk_count}()},
\code{\link{chk_date}()},
\code{\link{chk_date_time}()},
\code{\link{chk_false}()},
\code{\link{chk_flag}()},
\code{\link{chk_lgl}()},
\code{\link{chk_scalar}()},
\code{\link{chk_string}()},
\code{\link{chk_tz}()}
}
\concept{logical_checkers}
\concept{scalar_checkers}
