% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-count.R
\name{chk_count}
\alias{chk_count}
\alias{vld_count}
\title{Check Count}
\usage{
chk_count(x, x_name = NULL)

vld_count(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if non-negative whole number using

\code{vld_whole_number(x) && x >= 0}
}
\section{Functions}{
\itemize{
\item \code{vld_count()}: Validate Count

}}
\examples{
# chk_count
chk_count(1)
try(chk_count(1.5))
# vld_count
vld_count(1)
vld_count(0L)
vld_count(-1)
vld_count(0.5)
}
\seealso{
\code{\link[=vld_whole_number]{vld_whole_number()}}

\code{\link[=length]{length()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other scalar_checkers: 
\code{\link{chk_date}()},
\code{\link{chk_date_time}()},
\code{\link{chk_false}()},
\code{\link{chk_flag}()},
\code{\link{chk_lgl}()},
\code{\link{chk_scalar}()},
\code{\link{chk_string}()},
\code{\link{chk_true}()},
\code{\link{chk_tz}()}

Other whole_number_checkers: 
\code{\link{chk_whole_number}()},
\code{\link{chk_whole_numeric}()}
}
\concept{scalar_checkers}
\concept{whole_number_checkers}
