% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-htest-tidiers.R
\name{tidy.pairwise.htest}
\alias{tidy.pairwise.htest}
\title{Tidy a(n) pairwise.htest object}
\usage{
\method{tidy}{pairwise.htest}(x, ...)
}
\arguments{
\item{x}{A \code{pairwise.htest} object such as those returned from
\code{\link[stats:pairwise.t.test]{stats::pairwise.t.test()}} or \code{\link[stats:pairwise.wilcox.test]{stats::pairwise.wilcox.test()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row per group/group comparison and
columns:

\item{group1}{First group being compared}
\item{group2}{Second group being compared}
\item{p.value}{(Adjusted) p-value of comparison}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
Note that in one-sided tests, the alternative hypothesis of each
test can be stated as "group1 is greater/less than group2".

Note also that the columns of group1 and group2 will always be a factor,
even if the original input is (e.g.) numeric.
}
\examples{

attach(airquality)
Month <- factor(Month, labels = month.abb[5:9])
ptt <- pairwise.t.test(Ozone, Month)
tidy(ptt)

attach(iris)
ptt2 <- pairwise.t.test(Petal.Length, Species)
tidy(ptt2)

tidy(pairwise.t.test(Petal.Length, Species, alternative = "greater"))
tidy(pairwise.t.test(Petal.Length, Species, alternative = "less"))

tidy(pairwise.wilcox.test(Petal.Length, Species))

}
\seealso{
\code{\link[stats:pairwise.t.test]{stats::pairwise.t.test()}}, \code{\link[stats:pairwise.wilcox.test]{stats::pairwise.wilcox.test()}},
\code{\link[=tidy]{tidy()}}

Other htest tidiers: 
\code{\link{augment.htest}()},
\code{\link{tidy.htest}()},
\code{\link{tidy.power.htest}()}
}
\concept{htest tidiers}
