% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_utilities.R
\name{.formula_list_to_named_list}
\alias{.formula_list_to_named_list}
\title{Convert formula selector to a named list}
\usage{
.formula_list_to_named_list(
  x,
  data = NULL,
  var_info = NULL,
  arg_name = NULL,
  select_single = FALSE,
  type_check = NULL,
  type_check_msg = NULL,
  null_allowed = TRUE
)
}
\arguments{
\item{x}{list of selecting formulas}

\item{data}{A data frame to select columns from. Default is NULL}

\item{var_info}{A data frame of variable names and attributes. May also pass
a character vector of variable names. Default is NULL}

\item{arg_name}{Optional string indicating the source argument name. This
helps in the error messaging. Default is NULL.}

\item{select_single}{Logical indicating whether the result must be a single
variable. Default is \code{FALSE}}

\item{type_check}{A predicate function that checks the elements passed on
the RHS of the formulas in \verb{x=} (or the element in a named list)
satisfy the function.}

\item{type_check_msg}{When the \verb{type_check=} fails, the string provided
here will be printed as the error message. When \code{NULL}, a generic
error message will be printed.}

\item{null_allowed}{Are \code{NULL} values accepted for the right hand side of
formulas?}
}
\description{
Functions takes a list of formulas, a named list, or a combination of named
elements with formula elements and returns a named list.
For example, \code{list(age = 1, starts_with("stage") ~ 2)}.
}
\section{Shortcuts}{

A shortcut for specifying an option be applied to all columns/variables
is omitting the LHS of the formula.
For example, \code{list(~ 1)} is equivalent to passing \code{list(everything() ~ 1)}.

Additionally, a single formula may be passed instead of placing a single
formula in a list; e.g. \code{everything() ~ 1} is equivalent to
passing \code{list(everything() ~ 1)}
}

