% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.BTm.R
\name{anova.BTm}
\alias{anova.BTm}
\title{Compare Nested Bradley Terry Models}
\usage{
\method{anova}{BTm}(object, ..., dispersion = NULL, test = NULL)
}
\arguments{
\item{object}{a fitted object of class inheriting from \code{"BTm"}.}

\item{...}{additional \code{"BTm"} objects.}

\item{dispersion}{a value for the dispersion. Not implemented for models
with random effects.}

\item{test}{optional character string (partially) matching one of
\code{"Chisq"}, \code{"F"} or \code{"Cp"} to specify that p-values should be
returned.  The Chisq test is a likelihood ratio test for models with no
random effects, otherwise a Wald test. Options \code{"F"} and \code{"Cp"}
are only applicable to models with no random effects, see
\code{\link[=stat.anova]{stat.anova()}}.}
}
\value{
An object of class \code{"anova"} inheriting from class
\code{"data.frame"}.
}
\description{
Compare nested models inheriting from class \code{"BTm"}. For models with no
random effects, compute analysis of deviance table, otherwise compute Wald
tests of additional terms.
}
\details{
For models with no random effects, an analysis of deviance table is computed
using \code{\link[=anova.glm]{anova.glm()}}. Otherwise, Wald tests are computed as
detailed here.

If a single object is specified, terms are added sequentially and a Wald
statistic is computed for the extra parameters. If the full model includes
player covariates and there are players with missing values over these
covariates, then the \code{NULL} model will include a separate ability for
these players. If there are missing values in any contest-level variables in
the full model, the corresponding contests will be omitted throughout. The
random effects structure of the full model is assumed for all sub-models.

For a list of objects, consecutive pairs of models are compared by computing
a Wald statistic for the extra parameters in the larger of the two models.

The Wald statistic is always based on the variance-covariance matrix of the
larger of the two models being compared.
}
\section{Warning}{
 The comparison between two or more models will only be
valid if they are fitted to the same dataset. This may be a problem if there
are missing values and 's default of \code{na.action = na.omit} is used. An
error will be returned in this case.

The same problem will occur when separate abilities have been estimated for
different subsets of players in the models being compared. However no
warning is given in this case.
}

\examples{

result <- rep(1, nrow(flatlizards$contests))
BTmodel <- BTm(result, winner, loser, ~ throat.PC1[..] + throat.PC3[..] +
               head.length[..] + (1|..), data = flatlizards,
               trace = TRUE)
anova(BTmodel)

}
\seealso{
\code{\link[=BTm]{BTm()}}, \code{\link[=add1.BTm]{add1.BTm()}}
}
\author{
Heather Turner
}
\keyword{models}
