% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_matrix_functions.R, R/benchmarks.R
\name{bm_matrix_fun_fft}
\alias{bm_matrix_fun_fft}
\alias{bm_matrix_fun_eigen}
\alias{bm_matrix_fun_determinant}
\alias{bm_matrix_fun_cholesky}
\alias{bm_matrix_fun_inverse}
\alias{benchmark_matrix_fun}
\title{Matrix function benchmarks}
\usage{
bm_matrix_fun_fft(runs = 3, verbose = TRUE)

bm_matrix_fun_eigen(runs = 3, verbose = TRUE)

bm_matrix_fun_determinant(runs = 3, verbose = TRUE)

bm_matrix_fun_cholesky(runs = 3, verbose = TRUE)

bm_matrix_fun_inverse(runs = 3, verbose = TRUE)

benchmark_matrix_fun(runs = 3, verbose = TRUE, cores = 0L)
}
\arguments{
\item{runs}{Number of times to run the test. Default 3.}

\item{verbose}{Default TRUE.}

\item{cores}{Default 0 (serial). When cores > 0, the benchmark is run in parallel.}
}
\description{
A collection of matrix benchmark functions
\itemize{
\item FFT over 2,500,000 random values.
\item Eigenvalues of a 640x640 random matrix.
\item Determinant of a 2500x2500 random matrix.
\item Cholesky decomposition of a 3000x3000 matrix.
\item Inverse of a 1600x1600 random matrix.
}
These benchmarks have been developed by many authors.
See http://r.research.att.com/benchmarks/R-benchmark-25.R
for a complete history. The function \code{benchmark_matrix_fun()}
runs the five \code{bm} functions.
}
\references{
http://r.research.att.com/benchmarks/R-benchmark-25.R
}
