% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.amelia.R
\name{write.amelia}
\alias{write.amelia}
\title{Write Amelia imputations to file}
\usage{
write.amelia(
  obj,
  separate = TRUE,
  file.stem,
  extension = NULL,
  format = "csv",
  impvar = "imp",
  orig.data = TRUE,
  ...
)
}
\arguments{
\item{obj}{an object of class "amelia"; typically output from the
function \code{amelia}}

\item{separate}{logical variable. If \code{TRUE} (default), the
imputed datasets will be written to separate files, whose names come
from the \code{file.stem} and \code{extension} arguments. If \code{FALSE},
the imputations are stacked and written as a single file.}

\item{file.stem}{the leading part of the filename to save to
output The imputation number and \code{extension} will be added to
complete the filename. This can include a directory path.}

\item{extension}{the extension of the filename. This is simply what
follows \code{file.stem} and the imputation number.}

\item{format}{one of the following output formats: \code{csv},
\code{dta} or \code{table}. See details.}

\item{impvar}{the name of imputation number variable written to the
stacked dataset when \code{separate} is \code{FALSE}.}

\item{orig.data}{logical variable indicating whether the original,
unimputed dataset should be included in the stacked dataset when
\code{separate} is \code{FALSE}.}

\item{\dots}{further arguments for the \code{write} functions.}
}
\description{
Writes the imptuted datasets to file from a run of \code{amelia}
}
\details{
\code{write.amelia} writes the imputed datasets to a file or a set of files
using one of the following functions: \code{write.csv},
\code{write.dta}, or \code{write.table}. You can pass arguments to
these functions from \code{write.amelia}.

When \code{separate} is \code{TRUE}, each imputed dataset is written
to its own file. If you were to set \code{file.stem} to
\code{"outdata"} and the \code{extension} to \code{".csv"} , then the
resulting filename of the written files will be
\preformatted{
  outdata1.csv
  outdata2.csv
  outdata3.csv
  ...
}
and so on.

When \code{separate} is \code{FALSE}, the function adds a variable
called \code{impvar} to each dataset which indicates the imputed
dataset to which the row belongs. Then, each of the datasets are
stacked together to create one dataset. If \code{orig.data} is \code{TRUE},
then the original, unimputed dataset is included at the top of the
stack, with its imputation number set to 0.
}
\seealso{
\code{\link{write.csv}}, \code{\link{write.table}}, \code{\link{write.dta}}
}
