% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compoplot.R
\name{compoplot}
\alias{compoplot}
\alias{compoplot.matrix}
\alias{compoplot.dapc}
\alias{compoplot.snapclust}
\title{Genotype composition plot}
\usage{
compoplot(x, ...)

\method{compoplot}{matrix}(x, col.pal = funky, border = NA, subset = NULL,
  show.lab = FALSE, lab = rownames(x), legend = TRUE,
  txt.leg = colnames(x), n.col = 4, posi = NULL, cleg = 0.8,
  bg = transp("white"), ...)

\method{compoplot}{dapc}(x, only.grp = NULL, border = NA, ...)

\method{compoplot}{snapclust}(x, border = NA, ...)
}
\arguments{
\item{x}{an object to be used for plotting (see description)}

\item{...}{further arguments to be passed to \code{barplot}}

\item{col.pal}{a color palette to be used for the groups; defaults to \code{funky}}

\item{border}{a color for the border of the barplot; use \code{NA} to
indicate no border.}

\item{subset}{a subset of individuals to retain}

\item{show.lab}{a logical indicating if individual labels should be displayed}

\item{lab}{a vector of individual labels; if NULL, row.names of the matrix are used}

\item{legend}{a logical indicating whether a legend should be provided for the colors}

\item{txt.leg}{a character vector to be used for the legend}

\item{n.col}{the number of columns to be used for the legend}

\item{posi}{the position of the legend}

\item{cleg}{a size factor for the legend}

\item{bg}{the background to be used for the legend}

\item{only.grp}{a subset of groups to retain}
}
\description{
The compoplot uses a barplot to represent the group assignment probability of
individuals to several groups. It is a generic with methods for the following
objects:
}
\details{
\itemize{

\item \code{matrix}: a matrix with individuals in row and genetic clusters in
column, each entry being an assignment probability of the corresponding
individual to the corresponding group

\item \code{dapc}: the output of the \code{dapc} function; in this case,
group assignments are based upon geometric criteria in the discriminant space

\item \code{snapclust}: the output of the \code{snapclust} function; in
this case, group assignments are based upon the likelihood of genotypes
belonging to their groups

}
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
