% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCPM.R
\name{calculateCPM}
\alias{calculateCPM}
\alias{calculateCPM,ANY-method}
\alias{calculateCPM,SummarizedExperiment-method}
\alias{calculateCPM,SingleCellExperiment-method}
\title{Calculate CPMs}
\usage{
calculateCPM(x, ...)

\S4method{calculateCPM}{ANY}(
  x,
  size.factors = NULL,
  subset.row = NULL,
  size_factors = NULL,
  subset_row = NULL
)

\S4method{calculateCPM}{SummarizedExperiment}(x, ..., assay.type = "counts", exprs_values = NULL)

\S4method{calculateCPM}{SingleCellExperiment}(x, size.factors = NULL, ...)
}
\arguments{
\item{x}{A numeric matrix of counts where features are rows and cells are columns.

Alternatively, a \linkS4class{SummarizedExperiment} or a \linkS4class{SingleCellExperiment} containing such counts.}

\item{...}{For the generic, arguments to pass to specific methods.

For the SummarizedExperiment method, further arguments to pass to the ANY method.

For the SingleCellExperiment method, further arguments to pass to the SummarizedExperiment method.}

\item{size.factors}{A numeric vector containing size factors to adjust the library sizes.
If \code{NULL}, the library sizes are used directly.}

\item{subset.row}{A vector specifying the subset of rows of \code{x} for which to return a result.}

\item{size_factors, subset_row, exprs_values}{Soft-deprecated counterparts to the arguments above.}

\item{assay.type}{A string or integer scalar specifying the assay of \code{x} containing the count matrix.}
}
\value{
A numeric matrix of CPM values with the same dimensions as \code{x} (unless \code{subset.row} is specified).
}
\description{
Calculate counts-per-million (CPM) values from the count data.
}
\details{
If \code{size.factors} are provided or available in \code{x}, they are used to define the effective library sizes. 
This is done by scaling all size factors such that the mean factor is equal to the mean sum of counts across all features. 
The effective library sizes are then used as the denominator of the CPM calculation.
}
\examples{
example_sce <- mockSCE()
cpm(example_sce) <- calculateCPM(example_sce)
str(cpm(example_sce))
}
\seealso{
\code{\link{normalizeCounts}}, on which this function is based.
}
\author{
Aaron Lun
}
