% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/349-extractDrugXLogP.R
\name{extractDrugXLogP}
\alias{extractDrugXLogP}
\title{Descriptor that Calculates the Prediction of logP
Based on the Atom-Type Method Called XLogP}
\usage{
extractDrugXLogP(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{XLogP}.
}
\description{
Descriptor that Calculates the Prediction of logP
Based on the Atom-Type Method Called XLogP
}
\details{
Prediction of logP based on the atom-type method called XLogP.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugXLogP(mol)
head(dat)}
}
\references{
Wang, R., Fu, Y., and Lai, L.,
A New Atom-Additive Method for Calculating Partition Coefficients,
Journal of Chemical Information and Computer Sciences, 1997, 37:615-621.

Wang, R., Gao, Y., and Lai, L.,
Calculating partition coefficient by atom-additive method,
Perspectives in Drug Discovery and Design, 2000, 19:47-66.
}
