% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/301-extractDrugALOGP.R
\name{extractDrugALOGP}
\alias{extractDrugALOGP}
\title{Calculate Atom Additive logP and Molar Refractivity Values Descriptor}
\usage{
extractDrugALOGP(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature. This function returns three columns
named \code{ALogP}, \code{ALogp2} and \code{AMR}.
}
\description{
Calculate Atom Additive logP and Molar Refractivity Values Descriptor
}
\details{
Calculates ALOGP (Ghose-Crippen LogKow) and the Ghose-Crippen molar
refractivity as described by Ghose, A.K. and Crippen, G.M.
Note the underlying code in CDK assumes that aromaticity
has been detected before evaluating this descriptor.
The code also expects that the molecule will have
hydrogens explicitly set. For SD files, this is
usually not a problem since hydrogens are explicit.
But for the case of molecules obtained from SMILES,
hydrogens must be made explicit.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugALOGP(mol)
head(dat)}
}
\references{
Ghose, A.K. and Crippen, G.M. ,
Atomic physicochemical parameters for three-dimensional structure-directed
quantitative structure-activity relationships.
I. Partition coefficients as a measure of hydrophobicity,
Journal of Computational Chemistry, 1986, 7:565-577.

Ghose, A.K. and Crippen, G.M. ,
Atomic physicochemical parameters for three-dimensional-structure-directed
quantitative structure-activity relationships.
2. Modeling dispersive and hydrophobic interactions,
Journal of Chemical Information and Computer Science, 1987, 27:21-35.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{ALOGP}
\keyword{extractDrugALOGP}
