% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_enrichment_depletion.R
\name{plot_enrichment_depletion}
\alias{plot_enrichment_depletion}
\title{Plot enrichment/depletion of mutations in genomic regions}
\usage{
plot_enrichment_depletion(df, sig_type = c("fdr", "p"))
}
\arguments{
\item{df}{Dataframe result from enrichment_depletion_test()}

\item{sig_type}{The type of significance to be used. Possible values:
* 'fdr' False discovery rate.
A type of multiple testing correction.;
* 'p' for regular p values.}
}
\value{
Plot with two parts. 1: Barplot with no. mutations expected and
observed per region. 2: Effect size of enrichment/depletion
(log2ratio) with results significance test.
}
\description{
Plot enrichment/depletion of mutations in genomic regions
}
\examples{
## See the 'genomic_distribution()' example for how we obtained the
## following data:
distr <- readRDS(system.file("states/distr_data.rds",
  package = "MutationalPatterns"
))

tissue <- c(
  "colon", "colon", "colon",
  "intestine", "intestine", "intestine",
  "liver", "liver", "liver"
)

## Perform the enrichment/depletion test.
distr_test <- enrichment_depletion_test(distr, by = tissue)

## Plot the enrichment/depletion
plot_enrichment_depletion(distr_test)

#Perform and plot the enrichmet depletion test for all samples pooled
distr_test2 <- enrichment_depletion_test(distr)
plot_enrichment_depletion(distr_test2)

## Plot with p values instead of fdr
plot_enrichment_depletion(distr_test, sig_type = "p")

## Use multiple (max 3) significance cutoffs.
## This will vary the number of significance stars.
distr_multistars <- enrichment_depletion_test(distr,
  by = tissue,
  p_cutoffs = c(0.05, 0.01, 0.005),
  fdr_cutoffs = c(0.1, 0.05, 0.01)
)
plot_enrichment_depletion(distr_multistars)
}
\seealso{
\code{\link{enrichment_depletion_test}},
\code{\link{genomic_distribution}}
}
