% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgeneSim.R
\name{mgeneSim}
\alias{mgeneSim}
\title{Pairwise Semantic Similarity for a List of Genes}
\usage{
mgeneSim(
  genes,
  semData,
  measure = "Wang",
  drop = "IEA",
  combine = "BMA",
  verbose = TRUE
)
}
\arguments{
\item{genes}{A list of entrez gene IDs.}

\item{semData}{GOSemSimDATA object}

\item{measure}{One of "Resnik", "Lin", "Rel", "Jiang", "TCSS" and "Wang" methods.}

\item{drop}{A set of evidence codes based on which certain annotations are
dropped. Use NULL to keep all GO annotations.}

\item{combine}{One of "max", "avg", "rcmax", "BMA" methods, for combining
semantic similarity scores of multiple GO terms associated with protein or
multiple proteins assiciated with protein cluster.}

\item{verbose}{show progress bar or not.}
}
\value{
similarity matrix
}
\description{
Given a list of genes, this function calculates pairwise semantic
similarities.
}
\examples{

d <- godata('org.Hs.eg.db', ont="MF", computeIC=FALSE)
mgeneSim(c("835", "5261","241"), semData=d, measure="Wang")

}
\references{
Yu et al. (2010) GOSemSim: an R package for measuring semantic
similarity among GO terms and gene products \emph{Bioinformatics} (Oxford,
England), 26:7 976--978, April 2010. ISSN 1367-4803
\url{http://bioinformatics.oxfordjournals.org/cgi/content/abstract/26/7/976}
PMID: 20179076
}
\seealso{
\code{\link{goSim}} \code{\link{mgoSim}} \code{\link{geneSim}}
\code{\link{clusterSim}} \code{\link{mclusterSim}}
}
\keyword{manip}
