% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activateEnvironment.R
\name{activateEnvironment}
\alias{activateEnvironment}
\alias{deactivateEnvironment}
\title{Activate a Conda environment}
\usage{
activateEnvironment(envpath = NULL, loc = getCondaDir())

deactivateEnvironment(listing)
}
\arguments{
\item{envpath}{String containing the path to the Conda environment to activate.
If \code{NULL}, the base Conda instance at \code{\link{getCondaDir}()} is activated.}

\item{loc}{String containing the path to the root of a conda instance.}

\item{listing}{Named list of strings containing name:value pairs for environment variables,
typically the output of \code{activateEnvironment}.}
}
\value{
\code{activateEnvironment} will modify environment variables to mimic activation of the Conda environment.
It returns a named list of the previous values of all variables modified in this manner.
(\code{NA} values indicate that the corresponding variable was not previously set.)

\code{deactivateEnvironment} restores the environment variables to their pre-activation state.
It returns \code{NULL} invisibly.
}
\description{
Mimic the (de)activation of a Conda environment by modifying environment variables in the current R process.
}
\details{
Conda environments generally need to be activated to function properly.
This is especially relevant on Windows where the \code{"PATH"} variable needs to be modified for the DLL search.
The \code{.activateEnvironment} function mimics the effect of activation
by modifying environment variables in the current R session.
This can be reversed by \code{.deactivateEnvironment} once the Conda environment is no longer in use.

The \code{.activateEnvironment} function will also unset a few bothersome environment variables:
\itemize{
\item \code{"PYTHONPATH"}: to avoid compromising the version guarantees 
if \pkg{reticulate}'s \code{import} is allowed to search other locations beyond the specified Conda environment.
\item \code{"PYTHONNOUSERSITE"}: similarly, to avoid searching the user's site libraries.
\item \code{"RETICULATE_PYTHON"}: this would otherwise override any choice of Python, 
even after explicit specification via \pkg{reticulate}'s \code{use_Condaenv}!
\item \code{"RETICULATE_PYTHON_ENV"}: for similar reasons.
}
}
\examples{
# We can't actually run activateEnvironment() here, as it 
# either relies on basilisk already being installed or
# it has a hard-coded path to the basilisk system dir.
print("dummy test to pass BiocCheck")

}
\author{
Aaron Lun
}
