/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 Copyright (C) 2017 Klaus Spanderen

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <http://quantlib.org/license.shtml>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

/*! \file gbsmrndcalculator.hpp
    \brief risk neutral terminal density calculator for the
           Black-Scholes-Merton model with strike dependent volatility
*/

#ifndef quantlib_gbsm_risk_neutral_density_calculator_hpp
#define quantlib_gbsm_risk_neutral_density_calculator_hpp

#include <ql/experimental/finitedifferences/riskneutraldensitycalculator.hpp>
#include <boost/shared_ptr.hpp>

namespace QuantLib {
    class GeneralizedBlackScholesProcess;

    class GBSMRNDCalculator : public RiskNeutralDensityCalculator {
    public:
        explicit GBSMRNDCalculator(
            const boost::shared_ptr<GeneralizedBlackScholesProcess>& process);

        Real pdf(Real s, Time t) const;
        Real cdf(Real s, Time t) const;
        Real invcdf(Real q, Time t) const;

    private:
        const boost::shared_ptr<GeneralizedBlackScholesProcess> process_;
    };
}

#endif
