/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "qchateventfilter.h"

#include <QEvent>
#include <QKeyEvent>

#include "qchatsettings.h"
#include "chatwgt.h"
#include "singlemsgshistoryview.h"

// #include <QX11Info>
//
// #include <X11/X.h>
// #include <X11/Xlib.h>
// #include <X11/keysym.h>

QChatEventFilter::QChatEventFilter(QObject *parent)
 : QObject(parent),
  m_chatWgt(NULL)
{
//   int i;
//  int grab_keys[4] = {0x25, 0x40, 0x6d, 0x71}; /* alt and ctl keys */
//  for (i = 0; i < 4; i++)
//    XGrabKey(QX11Info::display(), grab_keys[i], AnyModifier, QX11Info::appRootWindow(), False, GrabModeAsync, GrabModeAsync);

//   XGrabKey(QX11Info::display(), XKeysymToKeycode(QX11Info::display(), XK_Escape), 0, QX11Info::appRootWindow(), False, GrabModeAsync, GrabModeAsync);
//   XGrabKey(QX11Info::display(), XKeysymToKeycode(QX11Info::display(), XK_H), AnyModifier, QX11Info::appRootWindow(), False, GrabModeAsync, GrabModeAsync);
//   XGrabKeyboard(QX11Info::display(), QX11Info::appRootWindow(), False, GrabModeAsync, GrabModeAsync, CurrentTime);
//   XSync(QX11Info::display(), False);
}


QChatEventFilter::~QChatEventFilter()
{
  qDebug("[~QChatEventFilter]");
}

bool QChatEventFilter::eventFilter(QObject* obj, QEvent* ev)
{
  QKeySequence seq;

  bool processed = false;

  if(ev->type() == QEvent::KeyPress/* 6*/)
  {
    QKeyEvent* keyEvent = static_cast<QKeyEvent*>(ev);
    seq = keyEvent->key() + keyEvent->modifiers();

    processed = true;

    if(QChatSettings::settings()->shortcuts("Hide2Tray").contains(seq))
      emit wantHide2Tray();
    else if(m_chatWgt)
    {
      if(QChatSettings::settings()->shortcuts("NextNewMessage").contains(seq))
        m_chatWgt->smhView()->nextNewMessage();

      else if(QChatSettings::settings()->shortcuts("PrevNewMessage").contains(seq))
        m_chatWgt->smhView()->prevNewMessage();

      else if(QChatSettings::settings()->shortcuts("NextOpenedMessage").contains(seq))
        m_chatWgt->smhView()->nextOpenedMessage();

      else if(QChatSettings::settings()->shortcuts("PrevOpenedMessage").contains(seq))
        m_chatWgt->smhView()->prevOpenedMessage();

      else if(QChatSettings::settings()->shortcuts("CloseAllNewMessages").contains(seq))
        m_chatWgt->smhView()->closeAllNewMessages();

      else if(QChatSettings::settings()->shortcuts("CloseAllOpenedMessages").contains(seq))
        m_chatWgt->smhView()->closeAllOpenedMessages();

      else
        processed = false;
     }
  }

  return processed ? true : QObject::eventFilter(obj, ev);
}

void QChatEventFilter::setChatWgt(ChatWgt* wgt)
{
  m_chatWgt = wgt;
}


