## Programs 

Here are some programs you can try out. If you've never used the program before, make sure you add the `--help` flag so it doesn't do something you don't expect. If you decide you want to install, you can run `pipx install PACKAGE` instead.

### ansible

IT automation

```
pipx install --include-deps ansible
```

### asciinema

Record and share your terminal sessions, the right way.

```
pipx run asciinema
```

### black

uncompromising Python code formatter

```
pipx run black
```

### pybabel

internationalizing and localizing Python applications

```
pipx run --spec=babel pybabel --help
```

### chardetect

detect file encoding

```
pipx run --spec=chardet chardetect --help
```

### cookiecutter

creates projects from project templates

```
pipx run cookiecutter
```

### create-python-package

easily create and publish new Python packages

```
pipx run create-python-package
```

### flake8

tool for style guide enforcement

```
pipx run flake8
```

### gdbgui

browser-based gdb debugger

```
pipx run gdbgui
```


### hexsticker

create hexagon stickers automatically

```
pipx run hexsticker
```

### ipython

powerful interactive Python shell

```
pipx run ipython
```

### jupyter

web-based notebook environment for interactive computing

```
pipx run jupyter
```

### pipenv

python dependency/environment management

```
pipx run pipenv
```

### poetry

python dependency/environment/packaging management

```
pipx run poetry
```

### pylint

source code analyzer

```
pipx run pylint
```

### pyinstaller

bundles a Python application and all its dependencies into a single package

```
pipx run pyinstaller
```

### pyxtermjs

fully functional terminal in the browser  

```
pipx run pyxtermjs
```

### shell-functools

Functional programming tools for the shell

```
pipx install shell-functools
```
