from ..properties import DistinguishedFolderId, FolderId
from .base import BaseFolder, Folder
from .collections import FolderCollection
from .known_folders import (
    NON_DELETABLE_FOLDERS,
    AdminAuditLogs,
    AllCategorizedItems,
    AllContacts,
    AllItems,
    AllPersonMetadata,
    AllTodoTasks,
    ApplicationData,
    ArchiveDeletedItems,
    ArchiveInbox,
    ArchiveMsgFolderRoot,
    ArchiveRecoverableItemsDeletions,
    ArchiveRecoverableItemsPurges,
    ArchiveRecoverableItemsRoot,
    ArchiveRecoverableItemsVersions,
    Audits,
    Birthdays,
    Calendar,
    CalendarLogging,
    CalendarSearchCache,
    CommonViews,
    CompanyContacts,
    Conflicts,
    Contacts,
    ConversationHistory,
    ConversationSettings,
    CrawlerData,
    DefaultFoldersChangeHistory,
    DeferredAction,
    DeletedItems,
    Directory,
    DlpPolicyEvaluation,
    Drafts,
    EventCheckPoints,
    ExchangeSyncData,
    ExternalContacts,
    Favorites,
    Files,
    FolderMemberships,
    FreeBusyCache,
    FreebusyData,
    Friends,
    FromFavoriteSenders,
    GALContacts,
    GraphAnalytics,
    IMContactList,
    Inbox,
    Inference,
    Journal,
    JunkEmail,
    LocalFailures,
    Location,
    MailboxAssociations,
    Messages,
    MsgFolderRoot,
    MyContacts,
    MyContactsExtended,
    NonDeletableFolder,
    Notes,
    OneNotePagePreviews,
    OrganizationalContacts,
    Outbox,
    ParkedMessages,
    PassThroughSearchResults,
    PdpProfileV2Secured,
    PeopleCentricConversationBuddies,
    PeopleConnect,
    PersonMetadata,
    QedcDefaultRetention,
    QedcLongRetention,
    QedcMediumRetention,
    QedcShortRetention,
    QuarantinedEmail,
    QuarantinedEmailDefaultCategory,
    QuickContacts,
    RecipientCache,
    RecoverableItemsDeletions,
    RecoverableItemsPurges,
    RecoverableItemsRoot,
    RecoverableItemsSubstrateHolds,
    RecoverableItemsVersions,
    RecoveryPoints,
    RelevantContacts,
    Reminders,
    RSSFeeds,
    Schedule,
    SearchFolders,
    SentItems,
    ServerFailures,
    ShadowItems,
    SharePointNotifications,
    Sharing,
    Shortcuts,
    ShortNotes,
    Signal,
    SkypeTeamsMessages,
    SmsAndChatsSync,
    SpoolerQueue,
    SwssItems,
    SyncIssues,
    System,
    System1,
    Tasks,
    TemporarySaves,
    ToDoSearch,
    UserCuratedContacts,
    Views,
    VoiceMail,
    WellknownFolder,
    WorkingSet,
)
from .queryset import DEEP, FOLDER_TRAVERSAL_CHOICES, SHALLOW, SOFT_DELETED, FolderQuerySet, SingleFolderQuerySet
from .roots import ArchiveRoot, PublicFoldersRoot, Root, RootOfHierarchy

__all__ = [
    "AdminAuditLogs",
    "AllCategorizedItems",
    "AllContacts",
    "AllItems",
    "AllPersonMetadata",
    "AllTodoTasks",
    "ApplicationData",
    "ArchiveDeletedItems",
    "ArchiveInbox",
    "ArchiveMsgFolderRoot",
    "ArchiveRecoverableItemsDeletions",
    "ArchiveRecoverableItemsPurges",
    "ArchiveRecoverableItemsRoot",
    "ArchiveRecoverableItemsVersions",
    "ArchiveRoot",
    "Audits",
    "BaseFolder",
    "Birthdays",
    "Calendar",
    "CalendarLogging",
    "CalendarSearchCache",
    "CommonViews",
    "CompanyContacts",
    "Conflicts",
    "Contacts",
    "ConversationHistory",
    "ConversationSettings",
    "CrawlerData",
    "DEEP",
    "DefaultFoldersChangeHistory",
    "DeferredAction",
    "DeletedItems",
    "Directory",
    "DistinguishedFolderId",
    "DlpPolicyEvaluation",
    "Drafts",
    "EventCheckPoints",
    "ExchangeSyncData",
    "ExternalContacts",
    "FOLDER_TRAVERSAL_CHOICES",
    "Favorites",
    "Files",
    "Folder",
    "FolderCollection",
    "FolderId",
    "FolderMemberships",
    "FolderQuerySet",
    "FreeBusyCache",
    "FreebusyData",
    "Friends",
    "FromFavoriteSenders",
    "GALContacts",
    "GraphAnalytics",
    "IMContactList",
    "Inbox",
    "Inference",
    "Journal",
    "JunkEmail",
    "LocalFailures",
    "Location",
    "MailboxAssociations",
    "Messages",
    "MsgFolderRoot",
    "MyContacts",
    "MyContactsExtended",
    "NON_DELETABLE_FOLDERS",
    "NonDeletableFolder",
    "Notes",
    "OneNotePagePreviews",
    "OrganizationalContacts",
    "Outbox",
    "ParkedMessages",
    "PassThroughSearchResults",
    "PdpProfileV2Secured",
    "PeopleCentricConversationBuddies",
    "PeopleConnect",
    "PersonMetadata",
    "PublicFoldersRoot",
    "QedcDefaultRetention",
    "QedcLongRetention",
    "QedcMediumRetention",
    "QedcShortRetention",
    "QuarantinedEmail",
    "QuarantinedEmailDefaultCategory",
    "QuickContacts",
    "RSSFeeds",
    "RecipientCache",
    "RecoverableItemsDeletions",
    "RecoverableItemsPurges",
    "RecoverableItemsRoot",
    "RecoverableItemsSubstrateHolds",
    "RecoverableItemsVersions",
    "RecoveryPoints",
    "RelevantContacts",
    "Reminders",
    "Root",
    "RootOfHierarchy",
    "SHALLOW",
    "SOFT_DELETED",
    "Schedule",
    "SearchFolders",
    "SentItems",
    "ServerFailures",
    "ShadowItems",
    "SharePointNotifications",
    "Sharing",
    "ShortNotes",
    "Shortcuts",
    "Signal",
    "SingleFolderQuerySet",
    "SkypeTeamsMessages",
    "SmsAndChatsSync",
    "SpoolerQueue",
    "SwssItems",
    "SyncIssues",
    "System",
    "System1",
    "Tasks",
    "TemporarySaves",
    "ToDoSearch",
    "UserCuratedContacts",
    "Views",
    "VoiceMail",
    "WellknownFolder",
    "WorkingSet",
]
