# pyOCD debugger
# Copyright (c) 2022 Analog Devices, Inc. 
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ...coresight.coresight_target import CoreSightTarget
from ...core.memory_map import (FlashRegion, RamRegion, MemoryMap)
from ...debug.svd.loader import SVDFile

FLASH_ALGO = {
    'load_address' : 0x20000000,

    # Flash algorithm as a hex string
    'instructions': [
    0xe7fdbe00,
    0x0181eb00, 0xd90b4281, 0xf8d26803, 0x4563c000, 0xf06fd002, 0x47700006, 0x1d121d00, 0xd8f34281,
    0x47702000, 0x43f8e92d, 0x460c4615, 0xf0104606, 0xd0270f03, 0x0003f026, 0x0803f006, 0x0704f1c8,
    0x90006800, 0x0004f1c7, 0x44084669, 0x4629463a, 0xfc6ef000, 0x0008eba6, 0xf0009900, 0x2800fb73,
    0xe8bdbf18, 0x443e83f8, 0x443d1be4, 0x4630e00a, 0xf0006829, 0x2800fb67, 0xe8bdbf18, 0x1f2483f8,
    0x1d361d2d, 0xd3022c04, 0x0f0ff016, 0x2c10d1ef, 0x4629d30c, 0xf0004630, 0x2800fb8d, 0xe8bdbf18,
    0x3c1083f8, 0x36103510, 0xd2f22c10, 0xd30c2c04, 0x68294630, 0xfb46f000, 0xbf182800, 0x83f8e8bd,
    0x1d2d1f24, 0x2c041d36, 0xb174d2f2, 0x90006830, 0x46294622, 0xf0004668, 0x4630fc70, 0xf0009900,
    0x2800fb31, 0xe8bdbf18, 0x200083f8, 0x83f8e8bd, 0x4601460b, 0xf0004618, 0x0000bc1b, 0xb8eaf000,
    0xf1a0b570, 0x4c365380, 0x0102f06f, 0x5284f1a0, 0x2fc0f5b3, 0xf5b2bf28, 0xd20f4f80, 0x2fc0f5b3,
    0xf020bf3c, 0xf02575fd, 0xd309457e, 0x4f80f5b2, 0xf3c0bf3c, 0xf500000d, 0xd30125c0, 0xbd704608,
    0xf0004620, 0x2800f880, 0xbd70bf18, 0x46204629, 0xf8f4f000, 0x4180f04f, 0xf042680a, 0x600a0240,
    0xf012680a, 0xd1fb0f40, 0xb570bd70, 0x4604460d, 0x0f0ff010, 0xf06fbf1c, 0xbd700002, 0x5280f1a4,
    0xf06f4b17, 0xf1a40002, 0xf5b25184, 0xbf242fc0, 0x4f80f5b1, 0xf5b2bd70, 0xbf3c2fc0, 0x71fdf024,
    0x417ef021, 0xf5b1d307, 0xbf3a4f80, 0x000df3c4, 0x21c0f500, 0x462abd70, 0xf0004618, 0xf04ff92d,
    0x68014080, 0x0140f041, 0x68036001, 0x0f40f013, 0x462ad1fb, 0xe8bd4620, 0x21044070, 0xbf10f7ff,
    0x40029000, 0x4180f04f, 0xf4006888, 0x48ac6260, 0x6f20f5b2, 0xf44fbf08, 0xd01b00e1, 0xf5b2dc09,
    0xbf086f80, 0xd00e48a7, 0x6fc0f5b2, 0x48a6bf08, 0xf5b2e009, 0xbf086f40, 0x4000f44f, 0xf5b2d003,
    0xbf086f60, 0xf5b248a1, 0xd1036f00, 0xf3c2688a, 0x40d03281, 0xf3c16889, 0x40c81182, 0x68804770,
    0x0007f000, 0x68814770, 0x0f07f011, 0xf06fbf1c, 0x47700005, 0x4380f04f, 0xf4016899, 0x49906260,
    0x6f20f5b2, 0xf44fbf08, 0xd01b01e1, 0xf5b2dc09, 0xbf086f80, 0xd00e498b, 0x6fc0f5b2, 0x498abf08,
    0xf5b2e009, 0xbf086f40, 0x4100f44f, 0xf5b2d003, 0xbf086f60, 0xf5b24985, 0xd1036f00, 0xf3c2689a,
    0x40d13281, 0xf3c2689a, 0x40d11282, 0xfbb14a80, 0x6041f1f2, 0xf0116a41, 0xd0030f02, 0xf0216a41,
    0x62410102, 0xf0216881, 0xf0414170, 0x60815100, 0x47702000, 0x68804877, 0x0007f000, 0xb5004770,
    0xf7ff4684, 0x2800ffb0, 0xbd00bf18, 0x0008f8dc, 0x407ff420, 0x402af440, 0x0008f8cc, 0x0008f8dc,
    0x0002f040, 0x0008f8cc, 0x0008f8dc, 0x0f07f010, 0xf8dcd1fa, 0xf0200008, 0xf8cc4070, 0xf8dc0008,
    0xf0100024, 0xbf080002, 0xf8dcbd00, 0xf0200024, 0xf8cc0002, 0xf06f0024, 0xbd000006, 0x4604b510,
    0xf4206880, 0xf440407f, 0x60a040aa, 0x68a06021, 0x0004f040, 0x0008f8c4, 0xfed0f7ff, 0xd1fb2800,
    0xf02068a0, 0x60a04070, 0xf0106a60, 0xbf080002, 0x6a60bd10, 0x0002f020, 0xf06f6260, 0xbd100006,
    0x45f0e92d, 0x2400b085, 0x46154698, 0x94004682, 0x94029401, 0x0f03f011, 0xbf1e9403, 0x0002f06f,
    0xe8bdb005, 0x680885f0, 0x0000ea35, 0xf06fbf1e, 0xb0050006, 0x85f0e8bd, 0x070ff001, 0x060ff021,
    0xf7ff4650, 0x2800ff40, 0xb005bf1c, 0x85f0e8bd, 0xf10646b4, 0x42860010, 0x4669bf38, 0xbf00d207,
    0x2b04f85c, 0x2024f841, 0x45841c64, 0xf8cad3f8, 0x2f048000, 0x9500bf38, 0x2f08d307, 0x9501bf38,
    0x2f0cd303, 0x9502bf34, 0x46699503, 0xf0004630, 0xb005f9d1, 0x85f0e8bd, 0x4614b530, 0x4684460d,
    0x0f0ff011, 0xf06fbf1c, 0xbd300002, 0xf7ff4660, 0x2800ff0a, 0xbd30bf18, 0x0008f8dc, 0x0010f020,
    0x0008f8cc, 0x5000f8cc, 0xf8cc6820, 0x68600030, 0x0034f8cc, 0xf8cc68a0, 0x68e00038, 0x003cf8cc,
    0x0008f8dc, 0x0001f040, 0x0008f8cc, 0x0008f8dc, 0x0f07f010, 0xf8dcd1fa, 0xf0200008, 0xf8cc4070,
    0xf8dc0008, 0xf0100024, 0xbf080002, 0xf8dcbd30, 0xf0200024, 0xf8cc0002, 0xf06f0024, 0xbd300006,
    0x05f5e100, 0x019dd180, 0x00013880, 0x047868c0, 0x000f4240, 0x40029000, 0x4770ba40, 0x4770ba40,
    0x4770ba40, 0x4770ba40, 0x4770bac0, 0x4770bac0, 0x4770bac0, 0x4770bac0, 0x0030ea4f, 0x00004770,
    0x0030ea4f, 0x00004770, 0x0030ea4f, 0x00004770, 0x0030ea4f, 0x00004770, 0xf04fb510, 0x24004180,
    0xf4406888, 0x60882000, 0xf012688a, 0xd0fb6f00, 0xf4206888, 0xf4406060, 0x60886000, 0xf412688a,
    0xd0fb5f00, 0xf8d0480e, 0xf0211100, 0xf8c00101, 0x20031100, 0xf985f000, 0xbd104620, 0x47702000,
    0xf000b510, 0x4240f8b8, 0xb510bd10, 0xf8c6f000, 0xbd104240, 0xf000b510, 0x4240f96a, 0x0000bd10,
    0x4002a000, 0x4080f04f, 0xf0416801, 0x60010140, 0xf0116801, 0xd1fb0f40, 0xf1a14770, 0x4ac25380,
    0x2fc0f5b3, 0xf1a1bf27, 0xf5b15184, 0x60024f80, 0xbf282000, 0x0002f06f, 0xf1a04770, 0xf5b25280,
    0xbf3c2fc0, 0x70fdf020, 0x407ef020, 0xf1a0d30b, 0xf5b25284, 0xbf394f80, 0x000df3c0, 0x20c0f500,
    0x0002f06f, 0x60084770, 0x47702000, 0x47702000, 0x460ab430, 0x0f03f010, 0xf06fbf1e, 0xbc300002,
    0xf0204770, 0xf1a0010f, 0xf06f5480, 0xf8df0302, 0xf5b4c298, 0xbf242fc0, 0x5484f1a0, 0x4f80f5b4,
    0xf1a1d213, 0xf5b45480, 0xbf3c2fc0, 0x73fdf021, 0x437ef023, 0xf1a1d30c, 0xf5b45484, 0xbf3c4f80,
    0x010df3c1, 0x23c0f501, 0xbc30d302, 0x47704618, 0x68094996, 0x6f80f411, 0xf06fbf1e, 0xbc300006,
    0x46014770, 0x4660bc30, 0xbe9af7ff, 0x488eb510, 0xfe45f7ff, 0xbf182800, 0xf04fbd10, 0x68014080,
    0x0140f041, 0x68016001, 0x0f40f011, 0x2000d1fb, 0xf1a0bd10, 0x4a845180, 0x2fc0f5b1, 0xf1a0bf21,
    0xf5b15184, 0xf06f4f80, 0x47700002, 0x46104601, 0xb928f000, 0x5180f1a0, 0xf5b14a7b, 0xbf212fc0,
    0x5184f1a0, 0x4f80f5b1, 0x0002f06f, 0x46014770, 0xf0004610, 0xb510b927, 0xf7ff4873, 0x2800fe10,
    0xbd10bf18, 0x4080f04f, 0xf0416801, 0x60010140, 0xf0116801, 0xd1fb0f40, 0xbd102000, 0x4601b570,
    0x5380f1a0, 0xf06f4c68, 0xf1a10002, 0xf5b35284, 0xbf242fc0, 0x4f80f5b2, 0xf5b3bd70, 0xbf3c2fc0,
    0x75fdf021, 0x457ef025, 0xf5b2d307, 0xbf3a4f80, 0x000df3c1, 0x25c0f500, 0x4620bd70, 0xfd93f7ff,
    0xbf182800, 0x4629bd70, 0xf7ff4620, 0xf04ffe07, 0x680a4180, 0x0240f042, 0x680a600a, 0x0f40f012,
    0xbd70d1fb, 0x460ab510, 0xf0104601, 0xf06f0f03, 0xd12d0302, 0x5480f1a1, 0xc12cf8df, 0x000ff021,
    0x2fc0f5b4, 0xf1a1bf24, 0xf5b45484, 0xd21f4f80, 0x5480f1a0, 0x2fc0f5b4, 0xf020bf3c, 0xf02373fd,
    0xd309437e, 0x5484f1a0, 0x4f80f5b4, 0xf3c0bf3c, 0xf500000d, 0xd20b23c0, 0x6800483c, 0x6f80f410,
    0xf06fbf18, 0xd1030306, 0xf7ff4660, 0x4603fde9, 0xbd104618, 0x460db570, 0xf0104604, 0xf06f0f0f,
    0xd0010102, 0xbd704608, 0x5280f1a4, 0xf1a44b2e, 0xf5b25084, 0xbf282fc0, 0x4f80f5b0, 0x2600d2f2,
    0x2fc0f5b2, 0xf024bf3c, 0xf02171fd, 0xd307417e, 0x4f80f5b0, 0xf3c4bf3c, 0xf500000d, 0xd2e121c0,
    0x4618462a, 0xfe08f7ff, 0x4080f04f, 0xf0416801, 0x60010140, 0xf0136803, 0xd1fb0f40, 0x2104462a,
    0xf7ff4620, 0x2800fbed, 0x4630bf08, 0xf7ffbd70, 0xf7ffbbf9, 0xf000bc5d, 0xf000b82b, 0xf000b835,
    0xf000b840, 0x4601b843, 0x5280f1a0, 0xf5b2480e, 0xbf212fc0, 0x5284f1a1, 0x4f80f5b2, 0x0002f06f,
    0xf0004770, 0x4601b83f, 0x5280f1a0, 0xf5b24806, 0xbf212fc0, 0x5284f1a1, 0x4f80f5b2, 0x0002f06f,
    0xf0004770, 0x0000b83f, 0x40029000, 0x40105408, 0x7040f410, 0xf06fbf04, 0x47700002, 0x6a4a491f,
    0x62484310, 0x47702000, 0x7040f410, 0xf06fbf04, 0x47700002, 0x6a4a4919, 0x0000ea22, 0x20006248,
    0x48164770, 0xf0006a40, 0x47700003, 0x0003f010, 0xf06fbf04, 0x47700002, 0x6a4a4910, 0x62484050,
    0x47702000, 0x5184f1a1, 0x4f00f5b1, 0xf06fbf24, 0x47700002, 0x6401490a, 0x6401490a, 0x6401490a,
    0x47702000, 0x5184f1a1, 0x4f00f5b1, 0xf06fbf24, 0x47700002, 0x64014905, 0x47702000, 0x40029000,
    0x3a7f5ca3, 0xa1e34f20, 0x9608b2c1, 0xdeadbeef, 0xf2402a03, 0xf0108030, 0xf0000c03, 0xf8118015,
    0xf1bc3b01, 0x44620f02, 0xf811bf98, 0xf800cb01, 0xbf383b01, 0x3b01f811, 0x0204f1a2, 0xf800bf98,
    0xbf38cb01, 0x3b01f800, 0x0303f011, 0x8025f000, 0xf0c03a08, 0xf8518008, 0x3a083b04, 0xcb04f851,
    0x1008e8a0, 0x1d12e7f5, 0xf851bf5c, 0xf8403b04, 0xf3af3b04, 0x07d28000, 0xf811bf24, 0xf8113b01,
    0xbf48cb01, 0x2b01f811, 0xf800bf24, 0xf8003b01, 0xbf48cb01, 0x2b01f800, 0xb5104770, 0xf0c03a20,
    0xe8b1800b, 0x3a205018, 0x5018e8a0, 0x5018e8b1, 0x5018e8a0, 0xaff5f4bf, 0x7c02ea5f, 0xe8b1bf24,
    0xe8a05018, 0xbf445018, 0xc018c918, 0x4010e8bd, 0x7c82ea5f, 0xf851bf24, 0xf8403b04, 0xbf083b04,
    0x07d24770, 0xf831bf28, 0xbf483b02, 0x2b01f811, 0xf820bf28, 0xbf483b02, 0x2b01f800, 0x00004770,
    0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x200004fd,
    'pc_unInit': 0x20000541,
    'pc_program_page': 0x20000559,
    'pc_erase_sector': 0x2000054f,
    'pc_eraseAll': 0x20000545,

    'static_base' : 0x20000000 + 0x00000004 + 0x00000a20,
    'begin_stack' : 0x20000c28,
    'begin_data' : 0x20000000 + 0x1000,
    'page_size' : 0x400,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x20001000, 0x20001400],   # Enable double buffering
    'min_program_length' : 0x400,

    # Relative region addresses and sizes
    'ro_start': 0x0,
    'ro_size': 0xa20,
    'rw_start': 0xa20,
    'rw_size': 0x4,
    'zi_start': 0xa24,
    'zi_size': 0x0,

    # Flash information
    'flash_start': 0x10000000,
    'flash_size': 0x5ffff,
    'sector_sizes': (
        (0x0, 0x2000),
    )
}

class MAX32670(CoreSightTarget):

    VENDOR = "Maxim"

    MEMORY_MAP = MemoryMap(
        FlashRegion(    start=0x10000000,  length=0x60000,  blocksize=0x2000, is_boot_memory=True, algo=FLASH_ALGO),
        RamRegion(      start=0x20000000,  length=0x28000),
        )

    def __init__(self, session):
        super().__init__(session, self.MEMORY_MAP)
        self._svd_location = SVDFile.from_builtin("max32670.svd")
