/*
 *@BEGIN LICENSE
 *
 * PSI4: an ab initio quantum chemistry software package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *@END LICENSE
 */

#include <libmints/mints.h>
#include <libciomr/libciomr.h>
#include <liboptions/liboptions.h>
#include <libchkpt/chkpt.h>
#include "psi4-dec.h"
#include "adc.h"

namespace psi{ namespace adc {
    
PsiReturnType
adc(Options &options)
{
    tstart();

    fprintf(outfile, "\n");
    fprintf(outfile, "\t****************************************\n");
    fprintf(outfile, "\t                 A D C                  \n");
    fprintf(outfile, "\t An Algebraic-Diagrammatic Construction \n");
    fprintf(outfile, "\t based on direct-product decomposition  \n");
    fprintf(outfile, "\t             Masaaki Saitow             \n");
    fprintf(outfile, "\t****************************************\n\n");
    fflush(outfile);

    //
    // I've never verified whether this Libtrans version works correctly with frozen orbitals. I first developed the ADC code with transqt2 
    // module and implemented in the previous Psi3. Due to circumvent the handling of VVVV-typed ERIs (generated by transqt2 by default),
    // this code is completely rewrtten in order to be better suited for Libtrans library, more flexible than transqt2. 
    //
    
    boost::shared_ptr<ADC> adc (new ADC());
    adc->compute_energy();
    
    tstop();
    
    fprintf(outfile, "\n");
    fprintf(outfile, "  ∩==\n"); 
    fprintf(outfile, "(: 3)))== kskkskkskksk         BOOOoooooOOOON!\n"); 
    fprintf(outfile, "  ∪==\n"); 
    fflush(outfile);

    return Success;
}
    
}} // End Namespaces
