/*
 * ----------------------------------------------------------------------------
 * xmouse - retrieves and sets X window mouse speeds
 *
 * Copyright 2000 Stephan Leemburg <stephan@jvc.nl>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------
 * $Log: xmouse.c,v $
 * Revision 1.1.1.1  2001/12/07 11:31:48  sleemburg
 * Initial CVS import of the unreleased pmud-0.8 to apmud (new project name
 * because of a name clash at sourceforge.net).
 *
 * Revision 1.1  2000/05/11 14:55:48  stephan
 * Initial revision
 *
 * ----------------------------------------------------------------------------
 */
static char *rcsid = "@(#)$Id: xmouse.c,v 1.1.1.1 2001/12/07 11:31:48 sleemburg Exp $";

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <X11/Xlib.h>

#define FLG_SET		(1<<0)

static void get_acceleration(char *arg, int *acceleration, int *denomination);
static int myxerror(Display *dp, XErrorEvent *e);

int main(int argc, char **argv)
{
	Display *dp;
	char *myname = strrchr(*argv, '/');
	char *display = 0;
	int acceleration = 0;
	int denomination = 0;
	int threshold = 0;
	int flags = 0;
	int op;

        extern char *optarg;
        extern int optind;
        extern int opterr;
        extern int optopt;

	myname = myname ? myname + 1 : *argv;

	while( (op=getopt(argc, argv, "d:a:t:")) != EOF )
		if(op == 'd')
		{
			display = optarg;
			break;
		}

	dp = XOpenDisplay(display);
	if(!dp)
		return 1;

	XSetErrorHandler(myxerror);
	XGetPointerControl(dp, &acceleration, &denomination, &threshold);

	for(optind = 0; (op=getopt(argc, argv, "d:a:t:")) != EOF; )
		switch(op)
		{
		case 'a':
			flags |= FLG_SET;
			get_acceleration(optarg, &acceleration, &denomination);
			break;
		case 't':
			flags |= FLG_SET;
			threshold = atoi(optarg);
			break;
		}

	if(flags&FLG_SET)
	{
		if(denomination <= 0)
			denomination = -1;

		XChangePointerControl(dp,
			True,
			True,
			acceleration,
			denomination,
			threshold
		);
	
		XGetPointerControl(dp, 
			&acceleration, 
			&denomination, 
			&threshold
		);
	}
	XCloseDisplay(dp);

	printf("%s -a %d/%d -t %d\n", 
		myname, 
		acceleration, 
		denomination, 
		threshold
	);
	
	return 0;
}

static void get_acceleration(char *arg, int *acceleration, int *denomination)
{
	register char *p;

	for(p = arg; *p; p++)
		if(*p == '/')
		{
			*p++ = 0;
			break;
		}
	*acceleration = atoi(arg);
	if(*p)
		*denomination = atoi(p);
}

static int myxerror(Display *dp, XErrorEvent *e)
{
	printf("error: %d\n", e->error_code);

	return 0;
}
