use Wx qw/wxFONTFAMILY_SWISS wxFONTSTYLE_NORMAL wxFONTWEIGHT_NORMAL wxFONTWEIGHT_BOLD  wxGREEN /;
use Wx::Calendar;
use Wx::DateTime;
use strict;
use Data::Dumper;
# Custom source
use Uploader::GUI::wxChoiceFilteredPanel;

use Wx qw( wxDefaultSize wxDefaultPosition wxNullAnimation wxNullFont wxBLACK );
use Wx qw( wxID_OK wxID_APPLY wxID_SAVE wxID_SAVEAS wxID_CANCEL wxID_YES wxID_NO wxID_EXIT wxID_ABOUT wxID_HELP );
use Wx qw( wxVERTICAL wxHORIZONTAL wxALL wxLEFT wxRIGHT wxTOP wxBOTTOM wxCENTRE wxGROW wxEXPAND);
use Wx qw( wxALIGN_RIGHT wxALIGN_BOTTOM wxALIGN_CENTER wxALIGN_CENTER_VERTICAL wxALIGN_CENTER_HORIZONTAL );
use Wx qw( wxTR_HAS_BUTTONS wxTR_LINES_AT_ROOT wxSUNKEN_BORDER wxLI_HORIZONTAL wxTE_MULTILINE );
use Wx qw( wxDP_DROPDOWN wxCB_READONLY);

# Bitmap functions

use Wx qw( wxNullBitmap wxBITMAP_TYPE_PNG );

# Window functions

use vars qw($PHOTO_PROPERTIES_NB); $PHOTO_PROPERTIES_NB = 10000;
use vars qw($PHOTO_PROPERTIES_CATEGORIES); $PHOTO_PROPERTIES_CATEGORIES = 10001;
use vars qw($ID_LINE); $ID_LINE = 10002;
use vars qw($PHOTO_PROPERTIES_UPLOAD); $PHOTO_PROPERTIES_UPLOAD = 10003;

sub PhotoPropertiesCategoriesTags {
    my( $parent, $categories ) = @_;


    my( $topsizer ) = Wx::BoxSizer->new( wxVERTICAL );

    $parent->{_multi_selection_mode_panel} = Wx::Panel->new(
        $parent,
        -1,
        wxDefaultPosition,
        [450, -1]
    );

    _multi_selection_mode_panel_layout(
        $parent->{_multi_selection_mode_panel}
    );

    $parent->{_multi_selection_mode_panel}->Show(0);

    $topsizer->Add(
        $parent->{_multi_selection_mode_panel},
        0,
        wxEXPAND|wxLEFT|wxRIGHT,
        5
    );


    # defines minimum size
    my( $item2 ) = Wx::Notebook->new( $parent, $main::PHOTO_PROPERTIES_NB, wxDefaultPosition, [450,-1], 0 );
    my( $item1 ) = $item2;
    if( Wx->VERSION < 0.21 ) {
        $item1 = Wx::NotebookSizer->new( $item2 );
    }
    $parent->{_properties_notebook} = $item2;
    
    # the notebook has adaptive size : stretch factor 2, wxEXPAND
    $topsizer->Add( $item1, 2, wxEXPAND|wxALL, 5 );

    # the notebook has adaptive size : stretch factor 1, wxEXPAND
    my ( $tree_categories ) = Uploader::GUI::wxCategoryTreeCtrl->new(
        {
            parentwnd  => $parent,
            id         => $main::PHOTO_PROPERTIES_CATEGORIES,
            categories => $categories,
        }
    );
    $tree_categories->Populate;
    my( $cat_sizer ) = Wx::BoxSizer->new( wxHORIZONTAL );
    $cat_sizer->Add( $tree_categories, 1, wxEXPAND|wxALL, 5 );

    $topsizer->Add( $cat_sizer, 1, wxEXPAND|wxALL, 5 );

    my( $item4 ) = Wx::StaticLine->new( $parent, $main::ID_LINE, wxDefaultPosition, [20,-1], wxLI_HORIZONTAL );
    $topsizer->AddWindow( $item4, 0, wxEXPAND|wxALL, 5 );

    my( $item5 ) = Wx::Button->new( $parent, $main::PHOTO_PROPERTIES_UPLOAD, "", wxDefaultPosition, [-1,40], 0 );
    my $btfont = Wx::Font->new(16, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD );
    $item5->SetFont($btfont);
    $item5->SetForegroundColour( Wx::Colour->new(255, 51, 99) );
    $topsizer->AddWindow( $item5, 0, wxEXPAND|wxALL, 5 );

    $parent->SetSizer( $topsizer );
    $topsizer->Fit( $parent );

    $topsizer;
}
use vars qw($TAGS); $TAGS = 10004;
use vars qw($PHOTO_PROPERTIES_TAG); $PHOTO_PROPERTIES_TAG = 10005;

sub photo_properties_tags {
    my( $parent, $tags ) = @_;
    my( $topsizer ) = Wx::BoxSizer->new( wxVERTICAL );
    
    $tags->{parentwnd}=$parent;
    my( $panel ) = Uploader::GUI::wxChoiceFilteredPanel->new($tags);
    # the panel has adaptive size : stretch factor 1, wxEXPAND
    $topsizer->AddWindow( $panel, 1, wxEXPAND|wxALL, 5 );

    $parent->SetSizer( $topsizer );
    $topsizer->Fit( $parent );
    
    $topsizer;
}

use vars qw($CAPTION); $CAPTION = 10006;
use vars qw($PHOTO_PROPERTIES_CAPTION); $PHOTO_PROPERTIES_CAPTION = 10007;
use vars qw($AUTHOR); $AUTHOR = 10008;
use vars qw($PHOTO_PROPERTIES_AUTHOR); $PHOTO_PROPERTIES_AUTHOR = 10009;
use vars qw($COMMENT); $COMMENT = 10010;
use vars qw($PHOTO_PROPERTIES_COMMENT); $PHOTO_PROPERTIES_COMMENT = 10011;
use vars qw($CREATE_DATE); $CREATE_DATE = 10012;
use vars qw($PHOTO_PROPERTIES_CREATE_DATE); $PHOTO_PROPERTIES_CREATE_DATE = 10013;
use vars qw($PRIVACY_LEVEL); $PRIVACY_LEVEL = 10014;
use vars qw($PHOTO_PROPERTIES_PRIVACY_LEVEL); $PHOTO_PROPERTIES_PRIVACY_LEVEL = 10015;


sub photo_properties_caption_comments {
    my( $parent ) = @_;

    my $topsizer = Wx::BoxSizer->new( wxVERTICAL );

    $topsizer->Add(
        ComboField(
            $parent,
            $main::CAPTION,
            $main::PHOTO_PROPERTIES_CAPTION
        ),
        0,
        wxEXPAND|wxALL,
        2
    );

    my $sizer_comment = Wx::BoxSizer->new( wxHORIZONTAL );
    $sizer_comment->Add( 
        TextField(
            $parent,
            $main::COMMENT,
            $main::PHOTO_PROPERTIES_COMMENT,
            1,
            wxTE_MULTILINE
        ),
        1,
        wxEXPAND|wxALL,
        2
    );

    $topsizer->Add( $sizer_comment, 1, wxEXPAND|wxALL, 2 );

    my $sizer_author_create = Wx::BoxSizer->new( wxVERTICAL );
    $sizer_author_create->Add( 
        TextField(
            $parent,
            $main::AUTHOR,
            $main::PHOTO_PROPERTIES_AUTHOR
        ),
        1,
        wxEXPAND|wxALL,
        2
    );

    $sizer_author_create->Add( 
        DatepickerField(
            $parent,
            $main::CREATE_DATE,
            $main::PHOTO_PROPERTIES_CREATE_DATE
        ),
        1,
        wxEXPAND|wxALL,
        2
    ); 

    my $sizer_author_create_privacy = Wx::BoxSizer->new( wxHORIZONTAL );

    my $sizer_privacy = Wx::BoxSizer->new( wxHORIZONTAL );

    $sizer_privacy->Add( 
        ChoiceField(
            $parent,
            $main::PRIVACY_LEVEL,
            $main::PHOTO_PROPERTIES_PRIVACY_LEVEL,
        ),
        1,
        wxALL,
        2
    );

    $sizer_author_create_privacy->Add($sizer_author_create, 0, wxEXPAND|wxALL, 0);
    $sizer_author_create_privacy->Add($sizer_privacy, 1, wxEXPAND|wxALL, 0);


    $topsizer->Add( $sizer_author_create_privacy, 0, wxEXPAND|wxALL, 2 );

    $parent->SetSizer( $topsizer );
    $topsizer->Fit( $parent );
    
    $topsizer;
}

use Wx qw( wxITEM_NORMAL wxITEM_RADIO wxITEM_CHECK );


sub TextField {
    my ( $parent, $id_label, $id_textctrl, $expand, $style ) = @_;

    $expand||=0;
    $style||0;

    my( $sizer ) = Wx::BoxSizer->new( wxVERTICAL );
    
    $sizer->Add( 
        Wx::StaticText->new(
            $parent,
            $id_label,
            "text",
            wxDefaultPosition,
            wxDefaultSize,
            0
        ),
        0,
        wxALL,
        1 
    );

    $sizer->Add( 
        Wx::TextCtrl->new(
            $parent,
            $id_textctrl,
            "",
            wxDefaultPosition,
            [-1,-1],
            $style 
        ),
        $expand,
        wxEXPAND|wxALL,
        1 
    );

    $sizer;
}

sub DatepickerField {
    my ( $parent, $id_label, $id_ctrl, $expand ) = @_;

    $expand ||=0;

    my( $sizer ) = Wx::BoxSizer->new( wxVERTICAL );
    
    $sizer->Add( 
        Wx::StaticText->new(
            $parent,
            $id_label,
            "text",
            wxDefaultPosition,
            wxDefaultSize,
            0
        ),
        0,
        wxALL,
        1 
    );

    $sizer->Add(
        Wx::DatePickerCtrl->new(
            $parent,
            $id_ctrl,
            Wx::DateTime->new(),
            wxDefaultPosition,
            [200,-1],
            wxDP_DROPDOWN
        ),
        $expand,
        wxEXPAND|wxALL,
        1 
    );

    $sizer;
}

sub ChoiceField {
    my ( $parent, $id_label, $id_ctrl, $expand ) = @_;

    $expand ||=0;

    my( $sizer ) = Wx::BoxSizer->new( wxVERTICAL );

    $expand||=0;
    
    $sizer->Add( 
        Wx::StaticText->new(
            $parent,
            $id_label,
            "text",
            wxDefaultPosition,
            wxDefaultSize,
            0
        ),
        0,
        wxALL,
        1 
    );

    $sizer->Add(
        Wx::Choice->new(
            $parent,
            $id_ctrl,
            wxDefaultPosition,
            [-1,-1],
            [],
            0
        ),
        $expand,
        wxEXPAND|wxALL,
        1 
    );

    $sizer;
}


sub ComboField {
    my ( $parent, $id_label, $id_ctrl, $expand ) = @_;

    $expand ||=0;

    my( $sizer ) = Wx::BoxSizer->new( wxVERTICAL );

    $expand||=0;
    
    $sizer->Add( 
        Wx::StaticText->new(
            $parent,
            $id_label,
            "text",
            wxDefaultPosition,
            wxDefaultSize,
            0
        ),
        0,
        wxALL,
        1 
    );

    my $ctrl = Wx::ComboBox->new(
        $parent,
        $id_ctrl,
        "",
        wxDefaultPosition,
        [-1,-1],
        [],
        
    );

    # the EVT_COMBOBOX has set _value if we need to overwrite the default
    # text. The list contains function names. We want to have the value returned by the function
    # in the text field
    Wx::Event::EVT_IDLE(
        $ctrl,
        sub { 
            my ( $ctrl, $event ) = @_;
            if(exists $ctrl->{_value}){
                $ctrl->SetValue($ctrl->{_value}) if !$ctrl->{_multi_selection_mode};
                delete $ctrl->{_value};
                delete $ctrl->{_multi_selection_mode};
            }
        } 
    );


    $sizer->Add(
        $ctrl,
        $expand,
        wxEXPAND|wxALL,
        1 
    );



    $sizer;
}


sub _multi_selection_mode_panel_layout{
    my ( $panel ) = @_;

    my( $item0 ) = Wx::BoxSizer->new( wxVERTICAL );

    my $fb = Wx::Font->new( 10, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD );
    my $fn = Wx::Font->new( 10, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL );

    $panel->{_text1} = Wx::StaticText->new( $panel, -1, "Text", wxDefaultPosition, wxDefaultSize, 0 );
    $panel->{_text1}->SetFont($fb);
    $item0->Add( $panel->{_text1}, 0, wxALIGN_LEFT|wxALL, 1 );

    
    $panel->{_text2} = Wx::StaticText->new( $panel, -1, "Text", wxDefaultPosition, wxDefaultSize, 0 );
    $panel->{_text2}->SetFont($fn);
    $item0->Add( $panel->{_text2}, 0, wxALIGN_LEFT|wxALL, 1 );

    $panel->SetSizer( $item0 );
    $item0->SetSizeHints( $panel );

}


use vars qw($CATEGORIES_ADD); $CATEGORIES_ADD = 10020;


1;

