#!/usr/bin/perl

require '../Functions/db.pl';
require '../Functions/config.pl';
require '../Functions/install_tests.pl';

our %conf = ();

LoadConfig();

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

print "<html><head><title>Installation check</title></head><body>\n";

print "<b>Mandatory perl modules :</b><br>\n<br>\n";
test_PerlModules_Mandatory();

print "<hr>\n";

print "<b>Optionnal perl modules :</b><br>\n<br>\n";
test_PerlModules_Optionnal();

print "<hr>\n";

print "<b>Additional tests :</b><br>\n<br>\n";
test_write_permissions( '..' );
test_db_access();
test_password_protection();

print "</body></html>";

sub my_print($$$)
{
	my $color = shift;
	my $label = shift;
	my $text = shift;

	print "<font color=$color>";
	if ( $color eq 'red' ) {print "<b>";};
	print $label;
	if ( $color eq 'red' ) {print "</b>";};
	print "</font> : ";
	print "$text<br>\n";
}
