sub Packet_Ethernet($$)
{
  my $Sdata=shift;
  my $Output_Type=shift;

  my $Output="<br>$Sdata<br><br>\n";

  if ($Output_Type eq 'STD')
  {
    if ($conf{'ettercap_mac_db'} and -f $conf{'ettercap_mac_db'})
    {
      my ($MAC_S,$MAC_T,$ETH_TYPE_L,$ETH_TYPE_N)=($Sdata =~ m/^(\S+) -> (\S+) \[ether_type=(\S+) \((\d+)\)\]$/);

      $MAC_S=get_Vendor_from_MAC_Address($MAC_S);
      $MAC_T=get_Vendor_from_MAC_Address($MAC_T);

      $Output.="Source : $MAC_S<br>\n";
      $Output.="Target : $MAC_T<br>\n";
      $Output.="Upper Layer (3/Transport) Protocol : $ETH_TYPE_N ($ETH_TYPE_L)";
    }
    else
    {
      &error("ettercap MAC vendor DB not found : $conf{'ettercap_mac_db'}");
    }
  }

  return $Output;
}

sub get_Vendor_from_MAC_Address($)
{
  my $MAC=shift;

  my @Elements=split(/:/,uc($MAC));
  my $Vendor=sprintf("%02s:%02s:%02s",@Elements[0..2]);
  my $ID=sprintf("%02s:%02s:%02s",@Elements[3..5]);

  if (($Vendor eq $ID) and ($Vendor eq 'FF:FF:FF'))
  {
    return 'Broadcast';
  }
  else
  {
    local *MAC_VENDOR_DB;
    undef $!;
    open(MAC_VENDOR_DB,$conf{'ettercap_mac_db'});
    if ($! and ($! !~ m/Inappropriate ioctl for device/i))
    {
      &error("Error opening ettercap mac-fingerprints DB : $!");
    }
    else
    {
      my $found=0;
      while(!$found and (my $line=<MAC_VENDOR_DB>))
      {
        if ($line =~ m/^$Vendor\s+(.*)$/)
        {
          $Vendor=$1.' ('.$Vendor.')';
          $Vendor =~ s/\r|\n//g;
          $found=1;
        }
      }
    }
    close(MAC_VENDOR_DB);

    return "$Vendor-$ID";
  }
}

sub Packet_ARP($$)
{
  my $Sdata=shift;
  my $Output_Type=shift;

  my $Output='';

# STD :
    if ($Output_Type eq 'STD')
    {
$Output=<<"EOB";
<br>$Sdata<br><br>
EOB
  }

  return $Output;
}

sub Packet_IPv4($$)
{
  my $Sdata=shift;
  my $Output_Type=shift;

  # source addr | dest addr | Ver | Hdr Len | TOS | length | ID | flags | offset | TTL | chksum || Options
  # 61.104.179.100 -> 81.91.66.90 [hl=20,version=4,tos=0,len=34,id=27096,ttl=113,prot=17,frag=[offset=64]]

  my $Output='';

  if ($Sdata =~ m/^([\d\.]+)\s+\-\>\s+([\d\.]+)\s+\[(.+)\]$/)
  {
    my ($Src_IP,$Tgt_IP,$Others)=($1,$2,$3);

    my %Others;
    foreach my $Key (split(/,/,$Others))
    {
      my ($K,$V)=split(/=/,$Key,2);
      $Others{$K}=$V;
    }

    if (!defined($Others{'frag'})) {$Others{'frag'}='[offset=]';};
    $Others{'frag'} =~ s/\[|\]|\s//g;
    my %Frag;
    foreach my $Key (split(/,/,$Others{'frag'}))
    {
      my ($K,$V)=split(/=/,$Key,2);
      if ($K eq 'DF') {$V='X';};
      $Frag{$K}=$V;
    }

    my %TOS;
    $TOS{'DS'}=(int($Others{'tos'}) & 252)/4;
    $TOS{'ECT'}=(int($Others{'tos'}) & 2)/2;
    $TOS{'CE'}=(int($Others{'tos'}) & 1);

# STD :
    if ($Output_Type eq 'STD')
    {
$Output=<<"EOB";
<br>$Sdata<br><br>
<table width=640 border=1 cellpadding=0 cellspacing=0>
  <tr>
    <td width=20 align=center>0</td>
    <td width=20 align=center>1</td>
    <td width=20 align=center>2</td>
    <td width=20 align=center>3</td>
    <td width=20 align=center>4</td>
    <td width=20 align=center>5</td>
    <td width=20 align=center>6</td>
    <td width=20 align=center>7</td>
    <td width=20 align=center>8</td>
    <td width=20 align=center>9</td>
    <td width=20 align=center>10</td>
    <td width=20 align=center>11</td>
    <td width=20 align=center>12</td>
    <td width=20 align=center>13</td>
    <td width=20 align=center>14</td>
    <td width=20 align=center>15</td>
    <td width=20 align=center>16</td>
    <td width=20 align=center>17</td>
    <td width=20 align=center>18</td>
    <td width=20 align=center>19</td>
    <td width=20 align=center>20</td>
    <td width=20 align=center>21</td>
    <td width=20 align=center>22</td>
    <td width=20 align=center>23</td>
    <td width=20 align=center>24</td>
    <td width=20 align=center>25</td>
    <td width=20 align=center>26</td>
    <td width=20 align=center>27</td>
    <td width=20 align=center>28</td>
    <td width=20 align=center>29</td>
    <td width=20 align=center>30</td>
    <td width=20 align=center>31</td>
  </tr>
  <tr class="packet">
    <td rowspan=2 colspan=4 align="center" height=30>IP Version=$Others{'version'}</td>
    <td rowspan=2 colspan=4 align="center">Hdr.Length=$Others{'hl'}</td>
    <td colspan=8 align="center">TOS=$Others{'tos'}</td>
    <td rowspan=2 colspan=16 align="center">Total Length=$Others{'len'}</td>
  </tr>
  <tr>
    <td colspan=6>DS=$TOS{'DS'}</td>
    <td>ECT=$TOS{'ECT'}</td>
    <td>CE=$TOS{'CE'}</td>
  </tr>
  <tr class="packet">
    <td rowspan=2 colspan=16 align="center" height=30>Identification=$Others{'id'}</td>
    <td rowspan=2 align="center"><font color=red>-</font></td>
    <td align="center">DF</td>
    <td align="center"><font color=red>MF</font></td>
    <td rowspan=2 colspan=13 align="center">Fragment Offset=$Frag{'offset'}</td>
  </tr>
  <tr class="packet">
    <td align="center">$Frag{'DF'}</td>
    <td align="center">&nbsp;</td>
  </tr>
  <tr class="packet">
    <td colspan=8 align="center" height=30>Time To Live=$Others{'ttl'}</td>
    <td colspan=8 align="center">Protocol Number=$Others{'prot'}</td>
    <td colspan=16 align="center"><font color=red>Header Checksum</red></td>
  </tr>
  <tr class="packet">
    <td colspan=32 align="center" height=30>32 bit Source Address=$Src_IP</td>
  </tr>
  <tr class="packet">
    <td colspan=32 align="center" height=30>32 bit Destination Address=$Tgt_IP</td>
  </tr>
  <tr class="packet">
    <td colspan=32 align="center" height=40><font color=red>Options (0 to 10 Words of 32 Bits)</font></td>
  </tr>
  </tr>
</table>

EOB
    }
  }

  return $Output;
}

sub Packet_TCP($$)
{
  my $Sdata=shift;
  my $Output_Type=shift;

# 35404 -> 80 [flags=PUSH ACK ,seq=980682701,ack=1555759336,win=39760]

# src prt | dst prt | R1 | R0 | URG | ACK | PSH | RST | SYN | FIN | seq | ack | offset | res | window | urp | CRC || options

  my $Output='';

  if ($Sdata =~ m/(\d+)\s->\s(\d+)\s+\[(.*)\]/)
  {
    my ($Src_P,$Tgt_P,$Others)=($1,$2,$3);
    my @Temp=split(/,/,$Others);
    my %Others;
    foreach my $Key (@Temp)
    {
      my ($K,$V)=split(/=/,$Key);
      $V =~ s/\s+$//;
      $Others{$K}=$V;
    }
    my @Flags=split(/\s+/,$Others{'flags'});
    my %Flags;
    foreach my $Flag (@Flags)
    {
      $Flags{$Flag}='X';
    }

# STD :
    if ($Output_Type eq 'STD')
    {
$Output=<<"EOB";
<br>$Sdata<br><br>
<table width=640 border=1 cellpadding=0 cellspacing=0>
  <tr>
    <td width=20 align=center>0</td>
    <td width=20 align=center>1</td>
    <td width=20 align=center>2</td>
    <td width=20 align=center>3</td>
    <td width=20 align=center>4</td>
    <td width=20 align=center>5</td>
    <td width=20 align=center>6</td>
    <td width=20 align=center>7</td>
    <td width=20 align=center>8</td>
    <td width=20 align=center>9</td>
    <td width=20 align=center>10</td>
    <td width=20 align=center>11</td>
    <td width=20 align=center>12</td>
    <td width=20 align=center>13</td>
    <td width=20 align=center>14</td>
    <td width=20 align=center>15</td>
    <td width=20 align=center>16</td>
    <td width=20 align=center>17</td>
    <td width=20 align=center>18</td>
    <td width=20 align=center>19</td>
    <td width=20 align=center>20</td>
    <td width=20 align=center>21</td>
    <td width=20 align=center>22</td>
    <td width=20 align=center>23</td>
    <td width=20 align=center>24</td>
    <td width=20 align=center>25</td>
    <td width=20 align=center>26</td>
    <td width=20 align=center>27</td>
    <td width=20 align=center>28</td>
    <td width=20 align=center>29</td>
    <td width=20 align=center>30</td>
    <td width=20 align=center>31</td>
  </tr>
  <tr class="packet2">
    <td colspan=16 align="center" height=30>Source Port=$Src_P</td>
    <td colspan=16 align="center">Destination Port=$Tgt_P</td>
  </tr>
  <tr class="packet2">
    <td colspan=32 align="center" height=30>Sequence Number=$Others{'seq'}</td>
  </tr>
  <tr class="packet2">
    <td colspan=32 align="center" height=30>Acknowledgement Number=$Others{'ack'}</td>
  </tr>
  <tr class="packet2">
    <td colspan=4 rowspan=2 align="center" height=30><font color=red>Data<BR>Offset</font></td>
    <td colspan=1 rowspan=2 align="center"><font color=red>-</font></td>
    <td colspan=1 rowspan=2 align="center"><font color=red>-</font></td>
    <td colspan=1 rowspan=2 align="center"><font color=red>-</font></td>
    <td colspan=1 rowspan=2 align="center"><font color=red>-</font></td>
    <td valign=bottom>C<br>W<br>R</td>
    <td valign=bottom>E<br>C<br>M<br>E</td>
    <td valign=bottom>U<br>R<br>G</td>
    <td valign=bottom>A<br>C<br>K</td>
    <td valign=bottom>P<br>U<br>S<br>H</td>
    <td valign=bottom>R<br>S<br>T</td>
    <td valign=bottom>S<br>Y<br>N</td>
    <td valign=bottom>F<br>I<br>N</td>
    <td colspan=16 rowspan=2 align="center">Window=$Others{'win'}</td>
  </tr>
  <tr class="packet2">
    <td>$Flags{'CWR'}</td>
    <td>$Flags{'ECME'}</td>
    <td>$Flags{'URG'}</td>
    <td>$Flags{'ACK'}</td>
    <td>$Flags{'PUSH'}</td>
    <td>$Flags{'RST'}</td>
    <td>$Flags{'SYN'}</td>
    <td>$Flags{'FIN'}</td>
  <tr>
  <tr class="packet2">
    <td colspan=16 align="center" height=30><font color=red>Checksum</font></td>
    <td colspan=16 align="center" height=30>Urgent Pointer=$Others{'urg'}</td>
  </tr>
  <tr class="paket2">
    <td colspan=32 align="center" height=40><font color=red>Options (0 to 10 Words of 32 Bits)</font></td>
  </tr>
</table>

EOB
    }
  }

  return $Output;
}

sub Packet_UDP($$)
{
  my $Sdata=shift;
  my $Output_Type=shift;

  my $Output='';

  if ($Sdata =~ m/(\d+)\s->\s(\d+)\s+\[(.*)\]/)
  {
    my ($Src_P,$Tgt_P,$Others)=($1,$2,$3);
    my @Temp=split(/,/,$Others);
    my %Others;
    foreach my $Key (@Temp)
    {
      my ($K,$V)=split(/=/,$Key);
      $V =~ s/\s+$//;
      $Others{$K}=$V;
    }

# STD :
    if ($Output_Type eq 'STD')
    {
$Output=<<"EOB";
<br>$Sdata<br><br>

<table width=640 border=1 cellpadding=0 cellspacing=0>
  <tr>
    <td width=20 align=center>0</td>
    <td width=20 align=center>1</td>
    <td width=20 align=center>2</td>
    <td width=20 align=center>3</td>
    <td width=20 align=center>4</td>
    <td width=20 align=center>5</td>
    <td width=20 align=center>6</td>
    <td width=20 align=center>7</td>
    <td width=20 align=center>8</td>
    <td width=20 align=center>9</td>
    <td width=20 align=center>10</td>
    <td width=20 align=center>11</td>
    <td width=20 align=center>12</td>
    <td width=20 align=center>13</td>
    <td width=20 align=center>14</td>
    <td width=20 align=center>15</td>
    <td width=20 align=center>16</td>
    <td width=20 align=center>17</td>
    <td width=20 align=center>18</td>
    <td width=20 align=center>19</td>
    <td width=20 align=center>20</td>
    <td width=20 align=center>21</td>
    <td width=20 align=center>22</td>
    <td width=20 align=center>23</td>
    <td width=20 align=center>24</td>
    <td width=20 align=center>25</td>
    <td width=20 align=center>26</td>
    <td width=20 align=center>27</td>
    <td width=20 align=center>28</td>
    <td width=20 align=center>29</td>
    <td width=20 align=center>30</td>
    <td width=20 align=center>31</td>
  </tr>
  <tr class="packet2">
    <td colspan=16 align="center" height=30>Source Port=$Src_P</td>
    <td colspan=16 align="center">Destination Port=$Tgt_P</td>
  </tr>
  <tr class="packet2">
    <td colspan=16 align="center" height=30>Total Length=$Others{'len'}</td>
    <td colspan=16 align="center" height=30><font color=red>Checksum (optional)</font></td>
  </tr>
</table>
EOB
    }
  }

  return $Output;
}

sub Packet_ICMP($$)
{
  my $Sdata=shift;
  my $Output_Type=shift;

  my $Output="<br>$Sdata<br><br>\n";

  return $Output;
}

1;
