#! /usr/bin/perl -w

use strict;
use warnings;

use CGI;

use DBI;

use Classes::User;

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/encode.pl';
require 'Functions/FakeFunctions.pl';

require 'Functions/_AlertDetails_XML.pl';

our $CurUser = User->new()->auth();

our %conf = ();	# configuration directives
our $cgi = '';	# CGI data

LoadConfig();

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

  # Open the DB connection :
our $dbh = DB_Open();

  # Import CGI parameters :
$cgi = CGI->new();

our $PageTitle = " - Alert's Details (XML/IDMEF)";
ParseComponent( 'CommonHeader' );
ParseComponent( 'Links' );

our $AlertId = int( $cgi->param( 'id' ) );

print<<"EOF";
<a href="AlertDetails$conf{'extension'}?id=$AlertId">Standard</a> / 
XML / 
<a href="AlertDetails_Packet$conf{'extension'}?id=$AlertId">Packet</a><br>
<br>
EOF

my @Path = ();
my %Exclude = ( 'parent_type', 1, 'parent_ident', 1, 'alert_ident', 1 );
my %Path = ();
my %ResNb = ();
my %Output = ();

local *XMLStruct;
open( XMLStruct, 'Struct.xml' );
while( my $Line = <XMLStruct> )
{
	foreach my $Elt ( split( /></, $Line ) )
	{
		$Elt =~ s/[^A-Za-z\/]//g;

		if ( $Elt =~ m/^(\/?)([A-Z]+)$/i )
		{
			my ( $TagEnd, $Tag ) = ( $1, $2 );
			if ( $TagEnd )
			{
				my $Indent = $#Path;
				my $Path = join( '/', @Path );

				$Output{$Path} = '&nbsp;&nbsp;'x$Indent;
				$Output{$Path} .= '&lt;/'.$Path[$Indent]."><br>\n";

				if ( $ResNb{$Path} )
				{
					print $Output{$Path};
				}

				pop @Path;
			}
			else
			{
				push @Path, $Tag;

				my $Indent = $#Path;
				my $Path = join( '/', @Path );

				$Output{$Path} = '&nbsp;&nbsp;'x$Indent;
				$Output{$Path} .= '&lt;'.$Path[$Indent]."><br>\n";

				my $Output;
				( $ResNb{$Path}, $Output ) = ShowValues( \@Path );
				$Output{$Path} .= $Output;

				if ( $ResNb{$Path} )
				{
					print $Output{$Path};
				}
			}
		}
	}
}
close( XMLStruct );

undef @Path;

ParseComponent( 'CommonFooter' );
