/*	Conductor Colors

PIRL CVS ID: Colors.java,v 1.4 2012/04/16 06:04:09 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package PIRL.Conductor;

import	java.awt.Color;


public class Colors
{
/**	Conductor Text style.
*/
public static Color
	NOTICE_STYLE				= Color.RED,
	HIGHLIGHT_STYLE				= Color.BLUE;

/**	Sources and Procedures Tables.
*/
public static Color
										//	Pale yellow.
	TABLE_HEADER				= new Color (247, 255, 165),
	TABLE_HEADER_SELECTED		= Selected_Color (true, TABLE_HEADER),
										//	Ivory.

	TABLE						= new Color (255, 255, 240),
	TABLE_SELECTED				= Selected_Color (true, TABLE),

										//	Leaf green.
	CURRENT_RECORD				= new Color (139,185,126),
										//	Sky blue.
	PROCESSED_RECORD			= new Color (168,189,233),
										//	Fire engine red.
	FAILURE_STATUS_FIELD		= new Color (193, 38, 38),
	FAILED_SOURCE_FIELD			= Color.ORANGE;


/**	Manager
*/
public static Color
	SUCCESS						= CURRENT_RECORD,
	POLLING						= PROCESSED_RECORD,
	FAILURE						= FAILURE_STATUS_FIELD,
	WARNING						= new Color (255, 234, 124),

	POLLING_BLINKER				= POLLING,
	RUNNING_BLINKER				= SUCCESS,
	WARNING_BLINKER				= WARNING,
	FAILURE_BLINKER				= FAILURE;

/**	Maestro Conductor_Table.
*/
public static Color
	RUNNING_STATE				= SUCCESS,
	POLLING_STATE				= POLLING,
	RUN_TO_WAIT					= new Color (150, 150, 255),
	WAITING_STATE				= new Color (200, 255, 255),
	HALTED_STATE				= FAILURE;

/**	Maestro Conductor_Matrix.
*/
public static Color
	ALTERNATE					= Color.WHITE,
	ALTERNATE_SELECTED			= Selected_Color (true, ALTERNATE);

/**	Kapellmeister.
*/
public static Color
	OPENED_THEATER				= SUCCESS,
	CLOSED_THEATER				= FAILURE,

	//	Message Monitor text style.
	MESSAGE_DELIVERED			= Color.YELLOW,
	MESSAGE_SENT				= Color.GREEN;

/*==============================================================================
	Utilities
*/
/**	Adjust the color to a possibly "selected" color.
<p>
	For a selected color ff all of the red, green or blue components of
	the given color have a value (in the range 0-255) greater than 175
	the color is {@link Color#darker() darkened}; otherwise the color is
	{@link Color#brighter() brightened}.
<p>
	@param	selected	true if the color is to be adjusted to the
		selected color; false if the color is to be returned unchanged.
	@param	color	The Color to be adjusted. If selected is false the
		color will be returned unchanged.
	@return	A Color that will have been modified if selected is true.
*/
public static Color Selected_Color
	(
	boolean	selected,
	Color	color
	)
{
if (selected)
	{
	if (color.getRed () > 175 &&
		color.getGreen () > 175 &&
		color.getBlue () > 175)
		color = color.darker ();
	else
		color = color.brighter ();
	}
return color;
}

}
