.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/comp/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.TH "PG_EXEC" "" "17 September 2020" "" "PostgreSQL Tcl Interface Documentation"

.SH NAME
pg_exec \- send a command to the server

.SH SYNOPSIS

.nf
pg_exec [\fI-paramarray\fR arrayVar] [\fI-variables\fR] \fIconn\fR \fIcommandString\fR [\fIargs\fR]
.fi
.SH "DESCRIPTION"
.PP
\fBpg_exec\fR submits a command to the
PostgreSQL server and returns a result.
Command result handles start with the connection handle and add a
period and a result number.
.PP
Note that lack of a Tcl error is not proof that the command
succeeded!  An error message returned by the server will be
processed as a command result with failure status, not by
generating a Tcl error in \fBpg_exec\fR\&.
Check for {[pg_result $result -status] == PGRES_COMMAND_OK}.
.PP
If the [-paramarray] flag is provided, then a substitution is performed on the query, securely replacing
each back-quote delimited name with the corresponding entry from the named array. If the array does not contain the named element,
then NULL is substituted (similarly to the way an array created by -withoutnulls is generated).
Each such name must occur in a location where a value or field name could appear. See pg_select for more info.
.PP
If the [-variables] flag is provided, then embedded Tcl variables are passed as parameters. Variables can be flagged with ':' and array references and namespaces are supported. Complex variable names can usually be embedded with :{nasty-name-here} though no attempt at duplicating Tcl brace-escaping is made.
If the variable does not exist, then NULL is substituted.
.SH "ARGUMENTS"
.TP
\fB[-paramarray arrayname]\fR
Perform parameter substitution via `quoted` elements of the array using PQexecParams or PQSendQueryParams.
.TP
\fB[-variables]\fR
Substitute Tcl variables found in the SQL string using PQexecParams or PQSendQueryParams.
.TP
\fB\fIconn\fB\fR
The handle of the connection on which to execute the command.
.TP
\fB\fIcommandString\fB\fR
The SQL command to execute.
.TP
\fB\fIargs\fB\fR
For PostgreSQL versions greater than 7.4, \fIargs\fR
consists of zero or more optional values that can be inserted,
unquoted, into the SQL statement using $-style substitution. Nulls are represented by the string "NULL".
.SH "RETURN VALUE"
.PP
A result handle. A Tcl error will be returned if
\fBpgtcl\fR was unable to obtain a server
response.  Otherwise, a command result object is created and a
handle for it is returned.  This handle can be passed to
\fBpg_result\fR to obtain the results of the
command.
.SH "EXAMPLE"
.PP

.nf
pg_exec $conn {select * from table1 where id = $1 and user = $2} $id $user
.fi
