/**
 *  Copyright 2007-2008 University Of Southern California
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package edu.isi.pegasus.planner.dax;

import java.util.regex.*;

/**
 *
 * @author gmehta
 * @version $Revision: 3009 $
 */
public class Patterns {

    private static Pattern mVersionPattern = Pattern.compile("^\\d+(\\.\\d+(\\.\\d+)?)?$");
    private static Pattern mNodeIdPattern = Pattern.compile("^[A-Za-z0-9][\\-A-Za-z0-9_]*$");

    public static boolean isValid(Pattern p, String s) {
        return p.matcher(s).matches();
    }

    public static boolean isVersionValid(String version) {
        return isValid(mVersionPattern, version);
    }

    public static boolean isNodeIdValid(String nodeid) {
        return isValid(mNodeIdPattern, nodeid);
    }
}
