*
* $Id: pfpaw.F,v 1.6 1997/10/23 13:00:28 mclareni Exp $
*
*   The dummy implementation for CERNLIB_WINNT has been introduced
*                                 Valery Fine
* $Log: pfpaw.F,v $
* Revision 1.6  1997/10/23 13:00:28  mclareni
* NT mods
*
* Revision 1.5  1996/09/18 14:26:09  dinofm
* A new PSYNC message has been added to allow the slaves to synchronise
* themselves before actually start to send to the client the points
* generated by a 2D scatter plot.
* Synchronization takes place only among the slaves that are working on
* a 'not empty' set of data.
*
* Revision 1.4  1996/05/06 13:31:00  dinofm
* Code modified to take care of empty histograms detection on slave(s).
*
* Revision 1.3  1996/04/29 09:03:11  cernlib
* Replace tabs by white space
*
* Revision 1.2  1996/04/18 08:41:52  dinofm
* A new pseudo-command PLABEL was added to compute the union of the labels
* set found by slaves (and broadcast it back)
*
* Revision 1.1.1.1  1996/03/01 11:38:46  mclareni
* Paw
*
*
#include "paw/pilot.h"
*CMZ :  2.04/15 11/03/94  20.52.52  by  Fons Rademakers
*-- Author :    Fons Rademakers   12/05/93
      SUBROUTINE PFPAW(CHMESS,CHLINE,NSLAV,ISLAV,ISTAT,EMASK)
************************************************************************
*                                                                      *
* Remote PAW procedure calls from the master server to the client or   *
* from a slave server to the master server. In case a slave calls the  *
* master, the master in turn makes an RPC to the client and, when      *
* necessary, relays the output parameter(s) back to the slave.         *
*                                                                      *
************************************************************************
*
#include "hbook/czbuff.inc"
#include "hbook/hcpiaf.inc"
#include "paw/pcntwk.inc"
#include "paw/pawchn.inc"
#include "paw/pccsel.inc"
#include "paw/gplotst.inc"
#include "paw/pchost.inc"
*
      PARAMETER    (MAXDIM = 13)
      CHARACTER*(*) CHMESS, CHLINE
      CHARACTER*16  CHOPT
      CHARACTER*80  CHMAIL, CHTITL, CHXVAR, CHYVAR, CHZVAR, CHTVAR
      INTEGER       EMASK
      INTEGER       NTSTOP, INIWRK, ENDWRK, INIPAN, PMASK, SYMASK, TMASK
      INTEGER       LENCHUNK,LENTOT,LREM,MAXBUFLEN,LGETUS,LABELCNT
      REAL          VLOW(MAXDIM), VUP(MAXDIM)
      SAVE          NTSTOP,INIWRK,ENDWRK,INIPAN,VLOW,VUP,PMASK,SYMASK
#ifdef CERNLIB_WINNT
      END
#else

*
      ISTAT = 0
*
      IF (CHMESS .EQ. 'PPROJ0') THEN
*
* Here we calculate the upper and lower limits of the default histogram.
* The final limits can only be calculated when we have received the limits
* from all slaves. Therefore this is a synchronisation point where all
* slaves have to wait. After the limits are calculated they are multicasted
* back to all slaves. This dialog is only between the slaves and the master.
* Never between the master and the client.
*
          INIT = 0
          IF (2**NSLAV-1 .EQ. SMASK) INIT = 1
*
          READ(CHLINE,'(I12)') NVAR
          CALL CZGETC(NVAR*30, ISTAT)
          IB = 1
          DO 10 I = 1, NVAR
             READ(CHBUF(IB:IB+30-1),'(2E15.9)') VL, VU
             IF (INIT .EQ. 1) THEN
                VLOW(I) = VL
                VUP(I)  = VU
             ELSE
                IF (VL .LT. VLOW(I)) VLOW(I) = VL
                IF (VU .GT. VUP(I))  VUP(I)  = VU
             ENDIF
             IB = IB + 30
  10      CONTINUE
*
          CALL PFMASK(ISLAV, SMASK, 0)
          IF (SMASK .EQ. 0) THEN
             IB = 1
             DO 20 I = 1, NVAR
                WRITE(CHBUF(IB:IB+30-1),'(2E15.9)') VLOW(I), VUP(I)
                IB = IB + 30
  20         CONTINUE
*
             DO 30 I = 1, NSLAV
                CALL PFSOCK(I)
                CALL CZPUTC(NVAR*30, ISTAT)
  30         CONTINUE
*
             CALL PFMASK(NSLAV, SMASK, -1)
          ENDIF
*
      ELSEIF (CHMESS .EQ. 'PLABEL') THEN
*
* Here we calculate the Union of the sets of labels for character columns.
* The Union set can only be calculated when we have received the partial sets
* from all slaves. Therefore this is a synchronisation point where all
* slaves have to wait. Once the Union set is computed is is multicasted
* back to all slaves. This dialog is only between the slaves and the master.
* Never between the master and the client.
*

*-------- Physical length of the communication buffer
          MAXBUFLEN = LEN (CHBUF)
*-------- Read the total length of data
          READ(CHLINE,'(I12)') LENTOT
*
          IF ( 2**NSLAV-1 .EQ. PMASK ) THEN 
*----------- 1st time: allocate the Union set using kind of approximated 
*----------- estimate of total no. of labels...
             CALL INITUS (1024)
          ENDIF
*-------- Read the physical buffers (for this slave) and add the 
*-------- 'decoded' content to the Union set
          DO 111 LREM = LENTOT , 0, -MAXBUFLEN
             LENCHUNK =  MIN(LREM,MAXBUFLEN)
             CALL CZGETC (LENCHUNK, ISTAT)
*----------- Add labels to the Union Set
             CALL ADDUS (CHBUF (1:LENCHUNK), LENCHUNK)
 111      CONTINUE
*
          CALL PFMASK(ISLAV, PMASK, 0)
          IF (PMASK .EQ. 0) THEN
*----------- All slaves sent their partial sets. Multicast the Union set back
*----------- Compute the lenght of the Union set as a string
             LENTOT = LGETUS()
             WRITE (CHSMPF,'(I12)') LENTOT

*----------- Send total length of the Union as a string to each slave
             DO 112 I = 1, NSLAV
                CALL PFSOCK(I)
                CALL CZPUTA (CHSMPF,ISTAT)
  112        CONTINUE

*----------- Compose the buffers required and multicast them to slaves
             LABELCNT = 0
             DO 114 LREM = LENTOT, 0, -MAXBUFLEN
                LENCHUNK = MAXBUFLEN
                CALL CGETUS (CHBUF,LENCHUNK,LABELCNT)
                DO 113 I = 1, NSLAV
                   CALL PFSOCK(I)
                   CALL CZPUTC(LENCHUNK, ISTAT)
  113           CONTINUE      
  114        CONTINUE
*
             CALL PFMASK(NSLAV, PMASK, -1)
*----------- Deallocate the Union set
             CALL RELUS
          ENDIF
*
      ELSEIF (CHMESS .EQ. 'PEMPTY') THEN
*
* If a slave produces an empty plot it notifies this to the master
* The master counts how many slaves sent such a notification. If all
* slaves did, the master relays the notification to the client.
* The client handle the notification in the same way the new QP would.
*

         L = LENOCC (CHLINE)
         IF (MASTPF) THEN
            CALL PFMASK(ISLAV, EMASK, 0)
            IF (EMASK .EQ. 0) THEN
*---- Old PAW client can't cope with PEMPTY command
               IF (ISPROTO.GE.2) THEN
                  CALL PFSOCK(0)
                  CALL PFEMPTY (CHLINE(1:L))
               ELSE
                  PRINT *, 'PIAF: no events selected'
               ENDIF
            ENDIF
         ELSE
            CALL HPLFRA(0.,10.,0.,10.,'A')
            CALL IGTEXT(5.,5.,'Empty',.3,0.,'C')
            CALL HPLTIT(CHLINE(1:L))
         ENDIF
*
      ELSEIF (CHMESS.EQ.'PSYNC') THEN
*
*-- Sync the slaves (e.g. before to start writing points in a scatter plot)
*-- Note that EMASK is used to take care only of the slaves that are
*-- working on a not-empty set of data
*   
          IF (MASTPF) THEN
            CALL PFMASK(ISLAV, SYMASK, 0)
            IF (IAND (SYMASK,EMASK) .EQ. 0) THEN
               CALL PFMASK(NSLAV, SYMASK, -1)
               WRITE(CHSMPF,'(A)') 'RESTART'
               DO 120 I = 1, NSLVPF
                  TMASK = EMASK
                  CALL PFMASK(I, TMASK, 0)
                  IF ( TMASK.NE.EMASK ) THEN
*-- Slave I is 'active'
                     CALL PFSOCK(I)
                     CALL CZPUTA(CHSMPF, ISTAT)
                  ENDIF
  120          CONTINUE
            ENDIF
         ENDIF
*
      ELSEIF (CHMESS .EQ. 'PNWORK') THEN
*
         READ(CHLINE,'(4I2,5I9,A16)') IMODE, NPASS, IPASS, NTCONT,
     +                                NCHAIN, IMINEV, IMAXEV,
     +                                MISBYT, IEDONE, CRHOST
         CALL CZGETA(CFILE,ISTAT)
*
         IF (MASTPF) THEN
*
* First time IMODE=1 we call PNWORK, after we ignore IMODE=1
* Last time IMODE=3 we call PNWORK, before we ignore IMODE=3
*
            CALL PFSOCK(0)
            IF (IMODE.EQ.1 .AND. INIWRK.EQ.0) THEN
               CALL PNWORK(IMODE)
               INIWRK = 1
            ELSEIF (IMODE .EQ. 2) THEN
*
* When in master do not propagate to client when client already told
* a previous slave to stop. Just tell this slave to stop too.
*
               IF (NTSTOP .EQ. 1) THEN
                  NTCONT = 1
                  GOTO 50
               ENDIF
               CALL PNWORK(IMODE)
               IF (NTCONT .EQ. 1) NTSTOP = 1
            ELSEIF (IMODE.EQ.3 .AND. ENDWRK+1.EQ.NSLAV) THEN
               CALL PNWORK(IMODE)
               INIWRK = 0
               ENDWRK = 0
            ELSEIF (IMODE .EQ. 3) THEN
               ENDWRK = ENDWRK + 1
               NTCONT = 1
            ENDIF
         ELSE
            CALL PNWORK(IMODE)
         ENDIF
  50     WRITE(CHMAIL,'(I2)') NTCONT
         IF (MASTPF) CALL PFSOCK(ISLAV)
         CALL CZPUTA(CHMAIL,ISTAT)
*
      ELSEIF (CHMESS .EQ. 'PACSEL') THEN
*
         CALL CZGETA(CHCSEL,ISTAT)
*
* Only propagate the cselect string coming from the first slave to the client
*
         IF (MASTPF) THEN
            IF (ISLAV .EQ. 1) THEN
               CALL PFSOCK(0)
               CALL PACSEL
            ENDIF
         ELSE
            CALL PACSEL
         ENDIF
*
      ELSEIF (CHMESS .EQ. 'PANT3D') THEN
*
* 3/4D Ntuple plot
*
         CHOPT = CHLINE
         CALL CZGETA(CHTITL,ISTAT)
         CALL CZGETA(CHMAIL,ISTAT)
         READ(CHMAIL,'(4E16.8)') XLO,XHI,YLO,YHI
         CALL CZGETA(CHMAIL,ISTAT)
         READ(CHMAIL,'(4E16.8)') ZLO,ZHI,TLO,THI
         CALL CZGETA(CHXVAR,ISTAT)
         CALL CZGETA(CHYVAR,ISTAT)
         CALL CZGETA(CHZVAR,ISTAT)
         CALL CZGETA(CHTVAR,ISTAT)
         LL=MAX(1,LENOCC(CHTITL))
         LX=MAX(1,LENOCC(CHXVAR))
         LY=MAX(1,LENOCC(CHYVAR))
         LZ=MAX(1,LENOCC(CHZVAR))
         LT=MAX(1,LENOCC(CHTVAR))
         LO=MAX(1,LENOCC(CHOPT))
*
* When master server, relay only the first call to PANT3D to the client
*
         IF (MASTPF) THEN
            IF (INIPAN .EQ. 0) THEN
               INIPAN = 1
               CALL PFSOCK(0)
               CALL PANT3D(XLO,XHI,YLO,YHI,ZLO,ZHI,TLO,THI,
     +                     CHXVAR(:LX),CHYVAR(:LY),CHZVAR(:LZ),
     +                     CHOPT(:LO))
            ENDIF
*
* Send back resulting change in /GPLOTST/
*
            WRITE(CHMAIL,'(4E16.8,I12)') (RMINP(I),I=1,4),ISTCNT
            INEW = 0
            IF (NEW) INEW = 1
            WRITE(CHTITL,'(4E16.8,I12)') (RMAXP(I),I=1,4),INEW
*
            CALL PFSOCK(ISLAV)
            CALL CZPUTA(CHMAIL,ISTAT)
            CALL CZPUTA(CHTITL,ISTAT)
*
         ELSE
            CALL PANT3D(XLO,XHI,YLO,YHI,ZLO,ZHI,TLO,THI,
     +                  CHXVAR(:LX),CHYVAR(:LY),CHZVAR(:LZ),
     +                  CHOPT(:LO))
*
* Send back resulting change in /GPLOTST/
*
            WRITE(CHMAIL,'(4E16.8,I12)') (RMINP(I),I=1,4),ISTCNT
            CALL CZPUTA(CHMAIL,ISTAT)
            INEW = 0
            IF (NEW) INEW = 1
            WRITE(CHMAIL,'(4E16.8,I12)') (RMAXP(I),I=1,4),INEW
            CALL CZPUTA(CHMAIL,ISTAT)
         ENDIF
*
      ELSEIF (CHMESS.EQ.'CLEAR') THEN
*
*-- Reset some flags
*
         NTSTOP = 0
         INIWRK = 0
         ENDWRK = 0
         INIPAN = 0
         CALL PFMASK(NSLAV, PMASK, -1)
         CALL PFMASK(NSLAV, SYMASK, -1)
*
      ELSE
         PRINT *,' PFPAW:',CHMESS,'?? '
      ENDIF
*
      END
#endif
