//=======================================================================
// removetab.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_REMOVE_TAB_H
#define GPACO_REMOVE_TAB_H

#include "util.h"
#include "pkg.h"
#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/textview.h>
#include <gtkmm/textbuffer.h>

namespace Gpaco
{

class PkgSet;

class RemoveTab : public Gtk::VBox
{
	enum {
		REPORT_REGULAR,
		REPORT_SYMLINK,
		REPORT_DIR,
		REPORT_ERROR,
		REPORT_SHARED,
		REPORT_UNLOG
	};

	public:

	RemoveTab(Pkg&);
	~RemoveTab();

	private:

	Pkg&							mPkg;
	PkgSet&							mPkgSet;
	Gtk::Label						mLabel;
	bool							mRemoveShared;
	Gtk::CheckButton				mButtonShared;
	Button							mButtonRemove;
	Button							mButtonStop;
	Button							mButtonResume;
	Gtk::TextView                   mTextView;
	Glib::RefPtr<Gtk::TextBuffer>   mpTextBuffer;
	Glib::RefPtr<Gtk::TextTag>      mpTagSuccess;
	Glib::RefPtr<Gtk::TextTag>      mpTagError;
	Glib::RefPtr<Gtk::TextTag>      mpTagShared;
	bool							mStop;

	void onSwitchRemoveShared();
	void onRemove();
	void onStop();
	void onResume();
	bool removeFile(File*);
	void report(std::string const&, int);
	void removeDir(std::string const&);

};

} // namespace Gpaco


#endif  // GPACO_REMOVE_TAB_H
