'\"
'\" Copyright (c) 2003-2006 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS1825 3  2006 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS1825
\- Programmable Resolution 1-Wire Digital Thermometer with ID
.TP
.B MAX31826
\- Digital Temperature Sensor with 1Kb Lockable EEPROM
.TP
.B MAX31850 MAX31851
\- Cold-Junction Compensated Thermocouple
.SH SYNOPSIS
.SS Thermometer with hardware address pins (DS1825)
.PP
.B 3B
[.]XXXXXXXXXXXX[XX][/[
.so man3/temperatures_mini.3so
|
.B power
|
.B prog_addr
|
.B temphigh
|
.B templow
|
.so man3/standard_mini.3so
]]
.SS Digital Temperature Sensor with 1Kb Lockable EEPROM (MAX31826)
.PP
.B 3B
[.]XXXXXXXXXXXX[XX][/[
.B temperature
|
.B power
|
.B memory
|
.B pages/page.[0-15|ALL]
|
.B prog_addr
|
.so man3/standard_mini.3so
]]
.SS Cold-Junction Compensated Thermocouple (MAX31850 and MAX31851)
.PP
.B 3B
[.]XXXXXXXXXXXX[XX][/[
.B temperature
|
.B thermocouple
|
.B fault
|
.B open_circuit
|
.B ground_short
|
.B vdd_short
|
.B power
|
.B prog_addr
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 3B
.SH SPECIAL PROPERTIES
.SS power
.I read-only,yes-no
.br
Is the chip powered externally (=1) or from the parasitically from the data bus (=0)?
.SS prog_addr
.I read-only, 0-15
.br
A distiguishing feature of the
.B DS1825 (3)
is the ability to set hardware pins for an address (0-15). This is an alternative to the unique 64-bit
.I address
that is set in the factory.
.SS temperature
.I read-only, floating point
.br
Measured temperature with 12 bit resolution.
.P
For the 
.B MAX31850 MAX 31851
this is the
.I cold-junction temperature
-- the temperature at the chip. See
.I thermocouple
.SS temperature9 temperature10 temperature11 temperature12
.I read-only, floating point
(
.B DS1825 
only)
.P
Measured temperature at 9 to 12 bit resolution. There is a tradeoff of time versus accuracy in the temperature measurement.
.PP
The
.B MAX31826 MAX31850 MAX31851
measure all temperatures at 12 bit resoltion and will return that resolution to all the possible temperature properties.
.SS fasttemp
.I read-only, floating point
.br
Equivalent to
.I temperature9
.SS thermocouple
.I read-only, floating point
(
.B MAX31850 MAX31851
only)
.P
Measured temperature of the thermocouple at 16bit resolution. Cold-junction temperature compensated.
.PP
The actual thermocouple type used is set by the selected chip type, and is not discoverable in software.
.so man3/temperature_threshold.3so
.PP
The 
.B MAX31826
does NOT have temperature thresholds and temperature alarm.
.SH MEMORY
Only the
.B MAX31826 
supports memory functions.
.SS pages/page.0 .. pages/page.15 pages/page.ALL
.I read/write, binary
.br
EEPROM memory pages of 8 bytes each. See the datasheet about locking contents.
.SS memory
.I read/write, binary
.br
EEPROM memory of 128 bytes. See the datasheet about locking contents.
.SH FAULT REPORTING
Only the
.B MAX31850 MAX31851
supports fault reporting.
.SS fault
.I read-only, yes-no
.br
Fault in last thermocouple conversion
.SS open_circuit
.I read-only, yes-no
.br
Thermocouple leads disconnected.
.SS ground_short
.I read-only, yes-no
.br
Thermocouple lead shorted to ground.
.SS vdd_short
.I read-only, yes-no
.br
Thermocouple lead shorted to supply voltage.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH DESCRIPTION
.so man3/description.3so
.SS DS1825
The
.B DS1825 (3)
is one of several available 1-wire temperature sensors. Alternatives are the
.B DS18S20 (3),
.B DS18B20 (3),
and
.B DS1822 (3)
as well as temperature/voltage measurements in the
.B DS2436 (3)
and
.B DS2438 (3).
For truly versatile temperature measurements, see the protean
.B DS1921 (3) Thermachron (3).
.PP
The
.B DS1825 (3)
can select between 4 resolutionsspanning the fastest/roughest and slowest/best.
.SS MAX31826
The
.B MAX31826
shares a family code with the
.B DS1825
but has differences in some of its functions.
.PP
The 
.B MAX31826
has 128 btes of EEPROM memory (as 16 pages of 8 bytes) while the
.B DS1825
has no memory available.
.PP
The 
.B MAX31826
measures temperature at 12 bit resolution as fast as the 
.B DS1825's
lowest resolution (and always uses 12-bit resolution). On the other hand it has no temperature thresholds or alarm function.
.SH ADDRESSING
.so man3/addressing.3so
.PP
Both the
.B MAX31826
and the 
.B DS1825
allow hardware selection of part of the address, which can assist selecting between chips is some circuit designs.
.SH DATASHEET
.TP
.B DS1825
http://pdfserv.maxim-ic.com/en/ds/DS1825.pdf
.TP
.B MAX31826
http://datasheets.maxim-ic.com/en/ds/MAX31826.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
