//----------------------------------------------------------------------------
//
// License:  See top level LICENSE.txt file.
//
// Author:  David Burken
//
// Description: Test application to spit out projection names from the
// projection factory registry.
//
// $Id$
//----------------------------------------------------------------------------

#include <vector>
#include <iostream>
#include <fstream>

using namespace std;

#include <ossim/init/ossimInit.h>
#include <ossim/base/ossimString.h>
#include <ossim/projection/ossimProjectionFactoryRegistry.h>
#include <ossim/projection/ossimStatePlaneProjectionFactory.h>

int main(int argc, char* argv[])   
{
   ossimInit::instance()->initialize(argc, argv);

//    if (argc != 2)
//    {
//       cout << "usage:  " << argv[0] << " <output_file.csv>" << endl;
//       return 0;
//    }

//    std::ofstream out(argv[1]);
//    if (!out)
//    {
//       return -1;
//    }

//    // Output the first line with the keys:
//    out << "\"NAME\","                       // 
//        << "\"PCS_CODE\","                   // 
//        << "\"PROJECTION\","            //
//        << "\"PARAM1\","                     //
//        << "\"PARAM2\","
//        << "\"PARAM3\","
//        << "\"PARAM4\","
//        << "\"FALSE_EASTING\","
//        << "\"FALSE_NORTHING\","
//        << "\"LINEAR_UNITS\","
//        << "\"DATUM_CODE\","
//        << endl;

   // const ossimStatePlaneProjectionInfo* info = 0;
   
   std::vector<ossimString> typeList;
   ossimStatePlaneProjectionFactory::instance()->getTypeNameList(typeList);

   std::vector<ossimString>::const_iterator i = typeList.begin();
   while (i < typeList.end())
   {
      
//       info = ossimStatePlaneProjectionFactory::instance()->getInfo(*i);
//       if (info)
//       {
//          out << "\""
//              << info->name() << "\","
//              << info->code() << ",\""
//              << info->projName() << "\","
//              << "
      
      std::cout << (*i) << std::endl;
      ++i;
   }

// out.close();
   
   return 0;
}

#if 0
int main()   
{
   ossimInit::instance()->initialize();
   
   std::vector<ossimString> typeList;
   ossimProjectionFactoryRegistry::instance()->getTypeNameList(typeList);

   std::vector<ossimString>::const_iterator i = typeList.begin();
   while (i < typeList.end())
   {
      std::cout << (*i) << std::endl;
      ++i;
   }
   
   return 0;
}
#endif

