#
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# This script is released under the GNU GPLv2
# Ref: Erik Sjlund
# 

if(description)
{
 script_id(16387);
 script_bugtraq_id(12527);
 script_cve_id("CVE-2005-0073");
 name = "Sympa queue utility privilege escalation vulnerability";

 script_name(name);
 script_version ("$Revision: 7589 $"); 
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 desc = "
The remote host seems to be running sympa, an open source mailing list 
management software.

The remote version of this software contains a vulnerability which can be 
exploited by malicious local user to gain escalated privileges.

This issue is caused due to a boundary error in the queue utility when 
processing command line arguments. This can cause a stack based buffer 
overflow.

Solution : Update to Sympa version 4.1.3 or newer
See also: http://www.sympa.org/
Risk factor : Medium";

 script_description(desc);
 summary = "Checks for sympa version";
 script_summary(summary);
 script_category(ACT_ATTACK);
 
 script_copyright("This script is Copyright (C) 2005 David Maciejak");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

#
# the code
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);


function check(url)
{
req = http_get(item:string(url, "home"), port:port);
r = http_keepalive_send_recv(port:port, data:req);
if ( r == NULL ) exit(0);

	if ("http://www.sympa.org/" >< r)
	{
        	if(egrep(pattern:".*ALT=.Sympa (2\.|3\.|4\.0|4\.1\.[012][^0-9])", string:r))
 		{
 			security_warning(port);
			exit(0);
		}
	}
}


foreach dir (cgi_dirs())
{
 check(url:dir);
}
