# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#
# References:
# From: "Michal Zalewski" <lcamtuf@echelon.pl>
# To: bugtraq@securityfocus.com
# CC: sendmail-security@sendmail.org
# Subject: RAZOR advisory: multiple Sendmail vulnerabilities

if(description)
{
 script_id(11088);
 script_bugtraq_id(3898);
 script_cve_id("CVE-2001-0715");
 script_version ("$Revision: 8289 $");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 
 name = "Sendmail debug mode leak";
 script_name(name);
 
 desc = "
According to the version number of the remote mail server, 
a local user may be able to obtain the complete mail configuration
and other interesting information about the mail queue even if
he is not allowed to access those information directly, by running
	sendmail -q -d0-nnnn.xxx
where nnnn & xxx are debugging levels.

If users are not allowed to process the queue (which is the default)
then you are not vulnerable.

Solution : upgrade to the latest version of Sendmail or 

do not allow users to process the queue (RestrictQRun option)
Risk factor : Low
Note : This vulnerability is _local_ only"; 



 script_description(desc);
		    
 
 summary = "Checks the version number for 'debug mode leak'"; 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 
 family = "SMTP problems";
 script_family(family);
 script_dependencie("find_service.nes","smtpserver_detect.nasl");
 script_require_ports("Services/smtp", 25);
 script_require_keys("SMTP/sendmail");
 exit(0);
}

#

include("smtp_func.inc");

port = get_kb_item("Services/smtp");
if(!port) port = 25;

banner = get_smtp_banner(port: port);
if(! banner || "Switch-" >< banner ) exit(0);

if(egrep(pattern:".*Sendmail.*8\.(([0-9]\..*)|(1[01]\..*)|(12\.0)).*",
	string:banner))
	security_warning(port);
