###############################################################################
# OpenVAS Vulnerability Test
# $Id: php_dec_2009.nasl 7518 2010-05-04 08:39:45Z chandra $
#
# PHP < 5.2.12 Multiple Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100409);
 script_bugtraq_id(37390,37389);
 script_cve_id("CVE-2009-4143","CVE-2009-4142");
 script_version ("1.0-$Revision: 7518 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");

 script_name("PHP < 5.2.12 Multiple Vulnerabilities");

desc = "Overview:
PHP is prone to a cross-site scripting vulnerability and to a code
execution vulnerability.

Attackers can exploit the code execution vulnerability to execute
arbitrary code within the context of the PHP process. This may allow
them to bypass intended security restrictions or gain elevated
privileges. 

An attacker may leverage the cross-site scripting vulnerabilit to
execute arbitrary script code in the browser of an unsuspecting user
in the context of the affected site. This may let the attacker steal
cookie-based authentication credentials and launch other attacks.

Versions prior to PHP 5.2.12 are vulnerable.

Solution:
Updates are available; please see the references for more information.

References:
http://www.securityfocus.com/bid/37390
http://www.securityfocus.com/bid/37389
http://www.php.net/ChangeLog-5.php#5.2.12
http://www.php.net/releases/5_2_12.php
http://www.php.net
http://www.suspekt.org/downloads/POC2009-ShockingNewsInPHPExploitation.pdf
http://www.blackhat.com/presentations/bh-usa-09/ESSER/BHUSA09-Esser-PostExploitationPHP-PAPER.pdf
http://d.hatena.ne.jp/t_komura/20091004/1254665511
http://bugs.php.net/bug.php?id=49785

Risk factor : High";

 script_description(desc);
 script_summary("Determine if php version is < 5.2.12");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("gb_php_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if(!can_host_php(port:port))exit(0);

if(!vers = get_kb_item(string("www/", port, "/PHP")))exit(0);

if(!isnull(vers)) {

  if(vers =~ "^5\.2") {
    if(version_is_less(version: vers, test_version: "5.2.12")) {
      security_hole(port:port);
      exit(0);
    }
  }
}

exit(0);

