# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8349 (apr-util)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64616);
 script_cve_id("CVE-2009-2412", "CVE-2009-0023");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 11 FEDORA-2009-8349 (apr-util)");

 desc = "The remote host is missing an update to apr-util
announced via advisory FEDORA-2009-8349.

Update Information:

CVE-2009-2412: allocator alignment fixes    Full details here:
http://www.apache.org/dist/apr/patches/

ChangeLog:

* Thu Aug  6 2009 Bojan Smojver  - 1.3.9-1
- bump up to 1.3.9
- CVE-2009-2412
- allocator alignment fixes
- disable DBM-drivers-as-DSO support

References:

[ 1 ] Bug #515698 - CVE-2009-2412 apr, apr-util: Integer overflows in memory pool (apr) and relocatable memory (apr-util) management
https://bugzilla.redhat.com/show_bug.cgi?id=515698

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update apr-util' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8349

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8349 (apr-util)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"apr-util", rpm:"apr-util~1.3.9~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-devel", rpm:"apr-util-devel~1.3.9~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-freetds", rpm:"apr-util-freetds~1.3.9~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-ldap", rpm:"apr-util-ldap~1.3.9~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-mysql", rpm:"apr-util-mysql~1.3.9~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-odbc", rpm:"apr-util-odbc~1.3.9~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-pgsql", rpm:"apr-util-pgsql~1.3.9~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-sqlite", rpm:"apr-util-sqlite~1.3.9~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-debuginfo", rpm:"apr-util-debuginfo~1.3.9~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
