# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1639-1 (twiki)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61640);
 script_cve_id("CVE-2008-3195");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1639-1 (twiki)";
 script_name(name);

 desc = "The remote host is missing an update to twiki
announced via advisory DSA 1639-1.

It was discovered that twiki, a web based collaboration platform,
didn't properly sanitize the image parameter in its configuration script.
This could allow remote users to execute arbitrary commands upon the
system, or read any files which were readable by the webserver user.

For the stable distribution (etch), this problem has been fixed in version
1:4.0.5-9.1etch1.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you upgrade your twiki package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201639-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1639-1 (twiki)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"twiki", ver:"4.0.5-9.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
